
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Org1Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SalesTaxRegistrationType" name="SalesTaxRegistration" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Org1Type implements Serializable
{
    private String name;
    private List<SalesTaxRegistrationType> salesTaxRegistrationList = new ArrayList<SalesTaxRegistrationType>();

    /** 
     * Get the 'Name' element value. Name of the organization
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Name of the organization
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the list of 'SalesTaxRegistration' element items. The Identification and contact information of a party purchasing goods or services as registered with a Purchase Tax.
     * 
     * @return list
     */
    public List<SalesTaxRegistrationType> getSalesTaxRegistrationList() {
        return salesTaxRegistrationList;
    }

    /** 
     * Set the list of 'SalesTaxRegistration' element items. The Identification and contact information of a party purchasing goods or services as registered with a Purchase Tax.
     * 
     * @param list
     */
    public void setSalesTaxRegistrationList(List<SalesTaxRegistrationType> list) {
        salesTaxRegistrationList = list;
    }
}
