
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A collection of segments which satisfies transportation of a passenger for a given origin and destination.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaxJourneyType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:MeasureType" name="DistanceMeasure" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Duration" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:InterlineSettlementInfoType" name="InterlineSettlementInfo" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxJourneyID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxSegmentRefID" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaxJourneyType implements Serializable
{
    private MeasureType distanceMeasure;
    private String duration;
    private InterlineSettlementInfoType interlineSettlementInfo;
    private String paxJourneyID;
    private List<String> paxSegmentRefIDList = new ArrayList<String>();

    /** 
     * Get the 'DistanceMeasure' element value. Total distance between the beginning and end stations of a leg, measured by the great circle of the earth.
     * 
     * @return value
     */
    public MeasureType getDistanceMeasure() {
        return distanceMeasure;
    }

    /** 
     * Set the 'DistanceMeasure' element value. Total distance between the beginning and end stations of a leg, measured by the great circle of the earth.
     * 
     * @param distanceMeasure
     */
    public void setDistanceMeasure(MeasureType distanceMeasure) {
        this.distanceMeasure = distanceMeasure;
    }

    /** 
     * Get the 'Duration' element value. Total journey time including the combined air time and connection times.  In case of stopover, this may or may not include stopover durations.
     * 
     * @return value
     */
    public String getDuration() {
        return duration;
    }

    /** 
     * Set the 'Duration' element value. Total journey time including the combined air time and connection times.  In case of stopover, this may or may not include stopover durations.
     * 
     * @param duration
     */
    public void setDuration(String duration) {
        this.duration = duration;
    }

    /** 
     * Get the 'InterlineSettlementInfo' element value. Information related to the value of a product or service as it pertains to interline transactions.
     * 
     * @return value
     */
    public InterlineSettlementInfoType getInterlineSettlementInfo() {
        return interlineSettlementInfo;
    }

    /** 
     * Set the 'InterlineSettlementInfo' element value. Information related to the value of a product or service as it pertains to interline transactions.
     * 
     * @param interlineSettlementInfo
     */
    public void setInterlineSettlementInfo(
            InterlineSettlementInfoType interlineSettlementInfo) {
        this.interlineSettlementInfo = interlineSettlementInfo;
    }

    /** 
     * Get the 'PaxJourneyID' element value. Uniquely identifies a Passenger Journey within the context of one message.
     * 
     * @return value
     */
    public String getPaxJourneyID() {
        return paxJourneyID;
    }

    /** 
     * Set the 'PaxJourneyID' element value. Uniquely identifies a Passenger Journey within the context of one message.
     * 
     * @param paxJourneyID
     */
    public void setPaxJourneyID(String paxJourneyID) {
        this.paxJourneyID = paxJourneyID;
    }

    /** 
     * Get the list of 'PaxSegmentRefID' element items. Reference to a Passenger Segment ID within this message.
     * 
     * @return list
     */
    public List<String> getPaxSegmentRefIDList() {
        return paxSegmentRefIDList;
    }

    /** 
     * Set the list of 'PaxSegmentRefID' element items. Reference to a Passenger Segment ID within this message.
     * 
     * @param list
     */
    public void setPaxSegmentRefIDList(List<String> list) {
        paxSegmentRefIDList = list;
    }
}
