
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Provides Payment Card details and commits the payment for the Offer(s) they wish to purchase. The Payment can take place either before or after the Order has been created.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PayerType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:IndividualType" name="Individual" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentCardType" name="PaymentCard" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PayerType implements Serializable
{
    private IndividualType individual;
    private PaymentCardType paymentCard;

    /** 
     * Get the 'Individual' element value. A single human being as distinct from a group, class, or family.
     * 
     * @return value
     */
    public IndividualType getIndividual() {
        return individual;
    }

    /** 
     * Set the 'Individual' element value. A single human being as distinct from a group, class, or family.
     * 
     * @param individual
     */
    public void setIndividual(IndividualType individual) {
        this.individual = individual;
    }

    /** 
     * Get the 'PaymentCard' element value. A device that enables its owner (the cardholder) to make a payment by electronic funds transfer.
     * 
     * @return value
     */
    public PaymentCardType getPaymentCard() {
        return paymentCard;
    }

    /** 
     * Set the 'PaymentCard' element value. A device that enables its owner (the cardholder) to make a payment by electronic funds transfer.
     * 
     * @param paymentCard
     */
    public void setPaymentCard(PaymentCardType paymentCard) {
        this.paymentCard = paymentCard;
    }
}
