
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AmountType" name="Amount" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ContactInfoRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DescType" name="Desc" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MerchantAccountType" name="MerchantAccount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OrderItemRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="OrderRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PayerType" name="Payer" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaymentInfoID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentMethodType" name="PaymentMethod" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaymentRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentStatusCodeContentType" name="PaymentStatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentTrxType" name="PaymentTrx" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="PriceVarianceAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PriceVarianceRuleType" name="PriceVarianceRule" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PromotionType" name="Promotion" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AmountType" name="SurchargeAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TypeCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="VerificationInd" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentInfoType implements Serializable
{
    private AmountType amount;
    private String contactInfoRefID;
    private DescType desc;
    private MerchantAccountType merchantAccount;
    private List<String> orderItemRefIDList = new ArrayList<String>();
    private String orderRefID;
    private PayerType payer;
    private String paymentInfoID;
    private PaymentMethodType paymentMethod;
    private String paymentRefID;
    private PaymentStatusCodeContentType paymentStatusCode;
    private PaymentTrxType paymentTrx;
    private AmountType priceVarianceAmount;
    private PriceVarianceRuleType priceVarianceRule;
    private List<PromotionType> promotionList = new ArrayList<PromotionType>();
    private AmountType surchargeAmount;
    private String typeCode;
    private Boolean verificationInd;

    /** 
     * Get the 'Amount' element value. The amount applied to the associated payment method.  Example: 300 USD
     * 
     * @return value
     */
    public AmountType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. The amount applied to the associated payment method.  Example: 300 USD
     * 
     * @param amount
     */
    public void setAmount(AmountType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'ContactInfoRefID' element value. Reference to the Payer's Contact ID within this message.
     * 
     * @return value
     */
    public String getContactInfoRefID() {
        return contactInfoRefID;
    }

    /** 
     * Set the 'ContactInfoRefID' element value. Reference to the Payer's Contact ID within this message.
     * 
     * @param contactInfoRefID
     */
    public void setContactInfoRefID(String contactInfoRefID) {
        this.contactInfoRefID = contactInfoRefID;
    }

    /** 
     * Get the 'Desc' element value. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @return value
     */
    public DescType getDesc() {
        return desc;
    }

    /** 
     * Set the 'Desc' element value. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @param desc
     */
    public void setDesc(DescType desc) {
        this.desc = desc;
    }

    /** 
     * Get the 'MerchantAccount' element value. A person or company that sells goods or services.
     * 
     * @return value
     */
    public MerchantAccountType getMerchantAccount() {
        return merchantAccount;
    }

    /** 
     * Set the 'MerchantAccount' element value. A person or company that sells goods or services.
     * 
     * @param merchantAccount
     */
    public void setMerchantAccount(MerchantAccountType merchantAccount) {
        this.merchantAccount = merchantAccount;
    }

    /** 
     * Get the list of 'OrderItemRefID' element items. Reference to an Order Item ID within this message.
     * 
     * @return list
     */
    public List<String> getOrderItemRefIDList() {
        return orderItemRefIDList;
    }

    /** 
     * Set the list of 'OrderItemRefID' element items. Reference to an Order Item ID within this message.
     * 
     * @param list
     */
    public void setOrderItemRefIDList(List<String> list) {
        orderItemRefIDList = list;
    }

    /** 
     * Get the 'OrderRefID' element value. Reference to an Order ID for this payment.
     * 
     * @return value
     */
    public String getOrderRefID() {
        return orderRefID;
    }

    /** 
     * Set the 'OrderRefID' element value. Reference to an Order ID for this payment.
     * 
     * @param orderRefID
     */
    public void setOrderRefID(String orderRefID) {
        this.orderRefID = orderRefID;
    }

    /** 
     * Get the 'Payer' element value. Provides Payment Card details and commits the payment for the Offer(s) they wish to purchase. The Payment can take place either before or after the Order has been created.
     * 
     * @return value
     */
    public PayerType getPayer() {
        return payer;
    }

    /** 
     * Set the 'Payer' element value. Provides Payment Card details and commits the payment for the Offer(s) they wish to purchase. The Payment can take place either before or after the Order has been created.
     * 
     * @param payer
     */
    public void setPayer(PayerType payer) {
        this.payer = payer;
    }

    /** 
     * Get the 'PaymentInfoID' element value. Uniquely identifies payment information within a message.
     * 
     * @return value
     */
    public String getPaymentInfoID() {
        return paymentInfoID;
    }

    /** 
     * Set the 'PaymentInfoID' element value. Uniquely identifies payment information within a message.
     * 
     * @param paymentInfoID
     */
    public void setPaymentInfoID(String paymentInfoID) {
        this.paymentInfoID = paymentInfoID;
    }

    /** 
     * Get the 'PaymentMethod' element value. A form of procedure for the payment of goods or services, plus any transactional information specific to the payment method other than the amount.
     * 
     * @return value
     */
    public PaymentMethodType getPaymentMethod() {
        return paymentMethod;
    }

    /** 
     * Set the 'PaymentMethod' element value. A form of procedure for the payment of goods or services, plus any transactional information specific to the payment method other than the amount.
     * 
     * @param paymentMethod
     */
    public void setPaymentMethod(PaymentMethodType paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    /** 
     * Get the 'PaymentRefID' element value. If creating the order after payment authorization it is a way of linking an order to an existing payment reference. not triggering the whole process again.
     * 
     * @return value
     */
    public String getPaymentRefID() {
        return paymentRefID;
    }

    /** 
     * Set the 'PaymentRefID' element value. If creating the order after payment authorization it is a way of linking an order to an existing payment reference. not triggering the whole process again.
     * 
     * @param paymentRefID
     */
    public void setPaymentRefID(String paymentRefID) {
        this.paymentRefID = paymentRefID;
    }

    /** 
     * Get the 'PaymentStatusCode' element value. Indicates the current status of this payment information.
     * 
     * @return value
     */
    public PaymentStatusCodeContentType getPaymentStatusCode() {
        return paymentStatusCode;
    }

    /** 
     * Set the 'PaymentStatusCode' element value. Indicates the current status of this payment information.
     * 
     * @param paymentStatusCode
     */
    public void setPaymentStatusCode(
            PaymentStatusCodeContentType paymentStatusCode) {
        this.paymentStatusCode = paymentStatusCode;
    }

    /** 
     * Get the 'PaymentTrx' element value. Additional identification and URLs used to further describe a secure payment transaction.
     * 
     * @return value
     */
    public PaymentTrxType getPaymentTrx() {
        return paymentTrx;
    }

    /** 
     * Set the 'PaymentTrx' element value. Additional identification and URLs used to further describe a secure payment transaction.
     * 
     * @param paymentTrx
     */
    public void setPaymentTrx(PaymentTrxType paymentTrx) {
        this.paymentTrx = paymentTrx;
    }

    /** 
     * Get the 'PriceVarianceAmount' element value. Price variance amount applied during Payment processing.
     * 
     * @return value
     */
    public AmountType getPriceVarianceAmount() {
        return priceVarianceAmount;
    }

    /** 
     * Set the 'PriceVarianceAmount' element value. Price variance amount applied during Payment processing.
     * 
     * @param priceVarianceAmount
     */
    public void setPriceVarianceAmount(AmountType priceVarianceAmount) {
        this.priceVarianceAmount = priceVarianceAmount;
    }

    /** 
     * Get the 'PriceVarianceRule' element value. Price Variance supports specifying Payment Processing Rules, including payment failure. Acceptable amount and/or percentage of the total amount by which the Order item price can vary. Example: 20 USD, 2 Percent
     * 
     * @return value
     */
    public PriceVarianceRuleType getPriceVarianceRule() {
        return priceVarianceRule;
    }

    /** 
     * Set the 'PriceVarianceRule' element value. Price Variance supports specifying Payment Processing Rules, including payment failure. Acceptable amount and/or percentage of the total amount by which the Order item price can vary. Example: 20 USD, 2 Percent
     * 
     * @param priceVarianceRule
     */
    public void setPriceVarianceRule(PriceVarianceRuleType priceVarianceRule) {
        this.priceVarianceRule = priceVarianceRule;
    }

    /** 
     * Get the list of 'Promotion' element items. Information related to publicizing  a product, organization, or venture so as to increase sales or public awareness.
     * 
     * @return list
     */
    public List<PromotionType> getPromotionList() {
        return promotionList;
    }

    /** 
     * Set the list of 'Promotion' element items. Information related to publicizing  a product, organization, or venture so as to increase sales or public awareness.
     * 
     * @param list
     */
    public void setPromotionList(List<PromotionType> list) {
        promotionList = list;
    }

    /** 
     * Get the 'SurchargeAmount' element value. Amount added to the final Offer/Order price, depending on which payment method is used by the client.
     * 
     * @return value
     */
    public AmountType getSurchargeAmount() {
        return surchargeAmount;
    }

    /** 
     * Set the 'SurchargeAmount' element value. Amount added to the final Offer/Order price, depending on which payment method is used by the client.
     * 
     * @param surchargeAmount
     */
    public void setSurchargeAmount(AmountType surchargeAmount) {
        this.surchargeAmount = surchargeAmount;
    }

    /** 
     * Get the 'TypeCode' element value. The payment method type. Examples: Credit Card, Cash.
     * 
     * @return value
     */
    public String getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' element value. The payment method type. Examples: Credit Card, Cash.
     * 
     * @param typeCode
     */
    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    /** 
     * Get the 'VerificationInd' element value. When true, this payment requires additional authentication.
     * 
     * @return value
     */
    public Boolean getVerificationInd() {
        return verificationInd;
    }

    /** 
     * Set the 'VerificationInd' element value. When true, this payment requires additional authentication.
     * 
     * @param verificationInd
     */
    public void setVerificationInd(Boolean verificationInd) {
        this.verificationInd = verificationInd;
    }
}
