
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A price point within a particular Cabin Type (sometimes referred to as 'Fare Families').
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceClassType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CabinTypeType" name="CabinType" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="Code" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DescType" name="Desc" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="DisplayOrderText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FareBasisAppText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FareBasisCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PriceClassID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceClassType implements Serializable
{
    private List<CabinTypeType> cabinTypeList = new ArrayList<CabinTypeType>();
    private String code;
    private List<DescType> descList = new ArrayList<DescType>();
    private String displayOrderText;
    private String fareBasisAppText;
    private String fareBasisCode;
    private String name;
    private String priceClassID;

    /** 
     * Get the list of 'CabinType' element items. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @return list
     */
    public List<CabinTypeType> getCabinTypeList() {
        return cabinTypeList;
    }

    /** 
     * Set the list of 'CabinType' element items. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @param list
     */
    public void setCabinTypeList(List<CabinTypeType> list) {
        cabinTypeList = list;
    }

    /** 
     * Get the 'Code' element value. Price class code.  Example: 1, ABC
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. Price class code.  Example: 1, ABC
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the list of 'Desc' element items. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @return list
     */
    public List<DescType> getDescList() {
        return descList;
    }

    /** 
     * Set the list of 'Desc' element items. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @param list
     */
    public void setDescList(List<DescType> list) {
        descList = list;
    }

    /** 
     * Get the 'DisplayOrderText' element value. The Airline requested default display order (in a client application) for this price class.  For example: 2.
     * 
     * @return value
     */
    public String getDisplayOrderText() {
        return displayOrderText;
    }

    /** 
     * Set the 'DisplayOrderText' element value. The Airline requested default display order (in a client application) for this price class.  For example: 2.
     * 
     * @param displayOrderText
     */
    public void setDisplayOrderText(String displayOrderText) {
        this.displayOrderText = displayOrderText;
    }

    /** 
     * Get the 'FareBasisAppText' element value. Fare basis application.  Examples: Requested, Ticketed, Other.
     * 
     * @return value
     */
    public String getFareBasisAppText() {
        return fareBasisAppText;
    }

    /** 
     * Set the 'FareBasisAppText' element value. Fare basis application.  Examples: Requested, Ticketed, Other.
     * 
     * @param fareBasisAppText
     */
    public void setFareBasisAppText(String fareBasisAppText) {
        this.fareBasisAppText = fareBasisAppText;
    }

    /** 
     * Get the 'FareBasisCode' element value. Fare basis code.  Example: Y26
     * 
     * @return value
     */
    public String getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'FareBasisCode' element value. Fare basis code.  Example: Y26
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(String fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    /** 
     * Get the 'Name' element value. Price class name.  Example: SUPERSAVER
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Price class name.  Example: SUPERSAVER
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'PriceClassID' element value. Uniquely Identifies a Price Class within the context of one message.
     * 
     * @return value
     */
    public String getPriceClassID() {
        return priceClassID;
    }

    /** 
     * Set the 'PriceClassID' element value. Uniquely Identifies a Price Class within the context of one message.
     * 
     * @param priceClassID
     */
    public void setPriceClassID(String priceClassID) {
        this.priceClassID = priceClassID;
    }
}
