
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Pricing history information for a given Order.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceQuoteType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AmountType" name="Amount" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CommissionType" name="Commission" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="PriceGuaranteeTimeLimitDateTime" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="QuoteDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SourceText" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceQuoteType implements Serializable
{
    private AmountType amount;
    private CommissionType commission;
    private String ownerCode;
    private DateTimeType priceGuaranteeTimeLimitDateTime;
    private DateTimeType quoteDateTime;
    private String sourceText;

    /** 
     * Get the 'Amount' element value. Quoted amount and currency information.
     * 
     * @return value
     */
    public AmountType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Quoted amount and currency information.
     * 
     * @param amount
     */
    public void setAmount(AmountType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'Commission' element value. An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * 
     * @return value
     */
    public CommissionType getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value. An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * 
     * @param commission
     */
    public void setCommission(CommissionType commission) {
        this.commission = commission;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'PriceGuaranteeTimeLimitDateTime' element value. Time limit information for this price quote.
     * 
     * @return value
     */
    public DateTimeType getPriceGuaranteeTimeLimitDateTime() {
        return priceGuaranteeTimeLimitDateTime;
    }

    /** 
     * Set the 'PriceGuaranteeTimeLimitDateTime' element value. Time limit information for this price quote.
     * 
     * @param priceGuaranteeTimeLimitDateTime
     */
    public void setPriceGuaranteeTimeLimitDateTime(
            DateTimeType priceGuaranteeTimeLimitDateTime) {
        this.priceGuaranteeTimeLimitDateTime = priceGuaranteeTimeLimitDateTime;
    }

    /** 
     * Get the 'QuoteDateTime' element value. Date time information related to the Price Quote.
     * 
     * @return value
     */
    public DateTimeType getQuoteDateTime() {
        return quoteDateTime;
    }

    /** 
     * Set the 'QuoteDateTime' element value. Date time information related to the Price Quote.
     * 
     * @param quoteDateTime
     */
    public void setQuoteDateTime(DateTimeType quoteDateTime) {
        this.quoteDateTime = quoteDateTime;
    }

    /** 
     * Get the 'SourceText' element value. ID or name of the source of this Transaction ID.  Examples: UA, ABC123.  Note: If this is an Airline ID, please use 'Owner Code'.
     * 
     * @return value
     */
    public String getSourceText() {
        return sourceText;
    }

    /** 
     * Set the 'SourceText' element value. ID or name of the source of this Transaction ID.  Examples: UA, ABC123.  Note: If this is an Airline ID, please use 'Owner Code'.
     * 
     * @param sourceText
     */
    public void setSourceText(String sourceText) {
        this.sourceText = sourceText;
    }
}
