
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The amount of money expected, required, or given in payment for something.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AmountType" name="BaseAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CurConversionType" name="CurConversion" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:DiscountType" name="Discount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="EquivAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:FeeType" name="Fee" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AmountType" name="LoyaltyUnitAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="LoyaltyUnitName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MarkupType" name="Markup" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:SurchargeType" name="Surcharge" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:TaxSummaryType" name="TaxSummary" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AmountType" name="TotalAmount" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceType implements Serializable
{
    private AmountType baseAmount;
    private List<CurConversionType> curConversionList = new ArrayList<CurConversionType>();
    private DiscountType discount;
    private AmountType equivAmount;
    private List<FeeType> feeList = new ArrayList<FeeType>();
    private AmountType loyaltyUnitAmount;
    private String loyaltyUnitName;
    private List<MarkupType> markupList = new ArrayList<MarkupType>();
    private List<SurchargeType> surchargeList = new ArrayList<SurchargeType>();
    private List<TaxSummaryType> taxSummaryList = new ArrayList<TaxSummaryType>();
    private AmountType totalAmount;

    /** 
     * Get the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000
     * 
     * @return value
     */
    public AmountType getBaseAmount() {
        return baseAmount;
    }

    /** 
     * Set the 'BaseAmount' element value. Total Base Fare Amount.  Example: 200000
     * 
     * @param baseAmount
     */
    public void setBaseAmount(AmountType baseAmount) {
        this.baseAmount = baseAmount;
    }

    /** 
     * Get the list of 'CurConversion' element items. The result of converting one currency into another currency. E.g. local currency to USD, air miles to monetary.
     * 
     * @return list
     */
    public List<CurConversionType> getCurConversionList() {
        return curConversionList;
    }

    /** 
     * Set the list of 'CurConversion' element items. The result of converting one currency into another currency. E.g. local currency to USD, air miles to monetary.
     * 
     * @param list
     */
    public void setCurConversionList(List<CurConversionType> list) {
        curConversionList = list;
    }

    /** 
     * Get the 'Discount' element value. Deduction from the price amount, made in advance of its payment.
     * 
     * @return value
     */
    public DiscountType getDiscount() {
        return discount;
    }

    /** 
     * Set the 'Discount' element value. Deduction from the price amount, made in advance of its payment.
     * 
     * @param discount
     */
    public void setDiscount(DiscountType discount) {
        this.discount = discount;
    }

    /** 
     * Get the 'EquivAmount' element value. The entire amount of transaction stated in the local currency at the point of sale, or the currency as defined by the Currency Indicator Code.
     * 
     * @return value
     */
    public AmountType getEquivAmount() {
        return equivAmount;
    }

    /** 
     * Set the 'EquivAmount' element value. The entire amount of transaction stated in the local currency at the point of sale, or the currency as defined by the Currency Indicator Code.
     * 
     * @param equivAmount
     */
    public void setEquivAmount(AmountType equivAmount) {
        this.equivAmount = equivAmount;
    }

    /** 
     * Get the list of 'Fee' element items. Amount added on to a charge for a specific product, purpose, or service.
     * 
     * @return list
     */
    public List<FeeType> getFeeList() {
        return feeList;
    }

    /** 
     * Set the list of 'Fee' element items. Amount added on to a charge for a specific product, purpose, or service.
     * 
     * @param list
     */
    public void setFeeList(List<FeeType> list) {
        feeList = list;
    }

    /** 
     * Get the 'LoyaltyUnitAmount' element value. Amount specified in loyalty units.  Note: the 'Currency Code' sup for this BDT should not be populated.
     * 
     * @return value
     */
    public AmountType getLoyaltyUnitAmount() {
        return loyaltyUnitAmount;
    }

    /** 
     * Set the 'LoyaltyUnitAmount' element value. Amount specified in loyalty units.  Note: the 'Currency Code' sup for this BDT should not be populated.
     * 
     * @param loyaltyUnitAmount
     */
    public void setLoyaltyUnitAmount(AmountType loyaltyUnitAmount) {
        this.loyaltyUnitAmount = loyaltyUnitAmount;
    }

    /** 
     * Get the 'LoyaltyUnitName' element value. The name of the loyalty unit used by the loyalty unit amount (e.g. miles or points).
     * 
     * @return value
     */
    public String getLoyaltyUnitName() {
        return loyaltyUnitName;
    }

    /** 
     * Set the 'LoyaltyUnitName' element value. The name of the loyalty unit used by the loyalty unit amount (e.g. miles or points).
     * 
     * @param loyaltyUnitName
     */
    public void setLoyaltyUnitName(String loyaltyUnitName) {
        this.loyaltyUnitName = loyaltyUnitName;
    }

    /** 
     * Get the list of 'Markup' element items. Defines the reason for the markup added by an airline as part of the offer reported as calculation detail.
     * 
     * @return list
     */
    public List<MarkupType> getMarkupList() {
        return markupList;
    }

    /** 
     * Set the list of 'Markup' element items. Defines the reason for the markup added by an airline as part of the offer reported as calculation detail.
     * 
     * @param list
     */
    public void setMarkupList(List<MarkupType> list) {
        markupList = list;
    }

    /** 
     * Get the list of 'Surcharge' element items. Amount added on to a usual charge for a specific product, purpose, or service.
     * 
     * @return list
     */
    public List<SurchargeType> getSurchargeList() {
        return surchargeList;
    }

    /** 
     * Set the list of 'Surcharge' element items. Amount added on to a usual charge for a specific product, purpose, or service.
     * 
     * @param list
     */
    public void setSurchargeList(List<SurchargeType> list) {
        surchargeList = list;
    }

    /** 
     * Get the list of 'TaxSummary' element items. Tax summary information.
     * 
     * @return list
     */
    public List<TaxSummaryType> getTaxSummaryList() {
        return taxSummaryList;
    }

    /** 
     * Set the list of 'TaxSummary' element items. Tax summary information.
     * 
     * @param list
     */
    public void setTaxSummaryList(List<TaxSummaryType> list) {
        taxSummaryList = list;
    }

    /** 
     * Get the 'TotalAmount' element value. Total monetary price amount, including all tax, surcharge, and fee amounts.
     * 
     * @return value
     */
    public AmountType getTotalAmount() {
        return totalAmount;
    }

    /** 
     * Set the 'TotalAmount' element value. Total monetary price amount, including all tax, surcharge, and fee amounts.
     * 
     * @param totalAmount
     */
    public void setTotalAmount(AmountType totalAmount) {
        this.totalAmount = totalAmount;
    }
}
