
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Promotion Issuer or Sponsor.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PromotionIssuerType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:CarrierType" name="Carrier" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrgType" name="Org" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TravelAgencyType" name="TravelAgency" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PromotionIssuerType implements Serializable
{
    private int choiceSelect = -1;
    private static final int CARRIER_CHOICE = 0;
    private static final int ORG_CHOICE = 1;
    private static final int TRAVEL_AGENCY_CHOICE = 2;
    private CarrierType carrier;
    private OrgType org;
    private TravelAgencyType travelAgency;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Carrier is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCarrier() {
        return choiceSelect == CARRIER_CHOICE;
    }

    /** 
     * Get the 'Carrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return value
     */
    public CarrierType getCarrier() {
        return carrier;
    }

    /** 
     * Set the 'Carrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param carrier
     */
    public void setCarrier(CarrierType carrier) {
        setChoiceSelect(CARRIER_CHOICE);
        this.carrier = carrier;
    }

    /** 
     * Check if Org is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOrg() {
        return choiceSelect == ORG_CHOICE;
    }

    /** 
     * Get the 'Org' element value. An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
     * 
     * @return value
     */
    public OrgType getOrg() {
        return org;
    }

    /** 
     * Set the 'Org' element value. An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
     * 
     * @param org
     */
    public void setOrg(OrgType org) {
        setChoiceSelect(ORG_CHOICE);
        this.org = org;
    }

    /** 
     * Check if TravelAgency is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTravelAgency() {
        return choiceSelect == TRAVEL_AGENCY_CHOICE;
    }

    /** 
     * Get the 'TravelAgency' element value. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @return value
     */
    public TravelAgencyType getTravelAgency() {
        return travelAgency;
    }

    /** 
     * Set the 'TravelAgency' element value. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @param travelAgency
     */
    public void setTravelAgency(TravelAgencyType travelAgency) {
        setChoiceSelect(TRAVEL_AGENCY_CHOICE);
        this.travelAgency = travelAgency;
    }
}
