
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Reservation change information which describes new flight information as it relates to a changed reservation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResChangeInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PaxSegmentRefType" name="PaxSegment" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ResStatusCode" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ResChangeInfoType implements Serializable
{
    private PaxSegmentRefType paxSegment;
    private String resStatusCode;

    /** 
     * Get the 'PaxSegment' element value. Transportation of a passenger on a Dated Operating Segment.
     * 
     * @return value
     */
    public PaxSegmentRefType getPaxSegment() {
        return paxSegment;
    }

    /** 
     * Set the 'PaxSegment' element value. Transportation of a passenger on a Dated Operating Segment.
     * 
     * @param paxSegment
     */
    public void setPaxSegment(PaxSegmentRefType paxSegment) {
        this.paxSegment = paxSegment;
    }

    /** 
     * Get the 'ResStatusCode' element value. This field contains the Reservation Status Code of the â€œReservation Changeâ€&#157; flight.
     * 
     * @return value
     */
    public String getResStatusCode() {
        return resStatusCode;
    }

    /** 
     * Set the 'ResStatusCode' element value. This field contains the Reservation Status Code of the â€œReservation Changeâ€&#157; flight.
     * 
     * @param resStatusCode
     */
    public void setResStatusCode(String resStatusCode) {
        this.resStatusCode = resStatusCode;
    }
}
