
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Row of passenger seats located in the cabin.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatRowType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="RowCharacteristicCode" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:integer" name="RowNumber" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SeatType" name="Seat" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatRowType implements Serializable
{
    private List<String> rowCharacteristicCodeList = new ArrayList<String>();
    private BigInteger rowNumber;
    private List<SeatType> seatList = new ArrayList<SeatType>();

    /** 
     * Get the list of 'RowCharacteristicCode' element items. Information and characteristics applying to a row of Passenger Seats (examples: XC - Exit Row, N - No Smoking Row, etc.).
     * 
     * @return list
     */
    public List<String> getRowCharacteristicCodeList() {
        return rowCharacteristicCodeList;
    }

    /** 
     * Set the list of 'RowCharacteristicCode' element items. Information and characteristics applying to a row of Passenger Seats (examples: XC - Exit Row, N - No Smoking Row, etc.).
     * 
     * @param list
     */
    public void setRowCharacteristicCodeList(List<String> list) {
        rowCharacteristicCodeList = list;
    }

    /** 
     * Get the 'RowNumber' element value. Ordinal number identifying a seat row in an aircraft.
     * 
     * @return value
     */
    public BigInteger getRowNumber() {
        return rowNumber;
    }

    /** 
     * Set the 'RowNumber' element value. Ordinal number identifying a seat row in an aircraft.
     * 
     * @param rowNumber
     */
    public void setRowNumber(BigInteger rowNumber) {
        this.rowNumber = rowNumber;
    }

    /** 
     * Get the list of 'Seat' element items. A sitting place for a passenger located in the cabin.
     * 
     * @return list
     */
    public List<SeatType> getSeatList() {
        return seatList;
    }

    /** 
     * Set the list of 'Seat' element items. A sitting place for a passenger located in the cabin.
     * 
     * @param list
     */
    public void setSeatList(List<SeatType> list) {
        seatList = list;
    }
}
