
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;

/** 
 * Condition under which an agreement is reached.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TermType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AvailPeriodType" name="AvailPeriod" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DescType" name="Desc" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrderingQtyType" name="OrderingQty" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TermID" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TermType implements Serializable
{
    private AvailPeriodType availPeriod;
    private DescType desc;
    private OrderingQtyType orderingQty;
    private String termID;

    /** 
     * Get the 'AvailPeriod' element value. Earliest and Latest Period than an option is available or may be used.
     * 
     * @return value
     */
    public AvailPeriodType getAvailPeriod() {
        return availPeriod;
    }

    /** 
     * Set the 'AvailPeriod' element value. Earliest and Latest Period than an option is available or may be used.
     * 
     * @param availPeriod
     */
    public void setAvailPeriod(AvailPeriodType availPeriod) {
        this.availPeriod = availPeriod;
    }

    /** 
     * Get the 'Desc' element value. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @return value
     */
    public DescType getDesc() {
        return desc;
    }

    /** 
     * Set the 'Desc' element value. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @param desc
     */
    public void setDesc(DescType desc) {
        this.desc = desc;
    }

    /** 
     * Get the 'OrderingQty' element value. Minimum/Maximum Option Ordering Quantities.
     * 
     * @return value
     */
    public OrderingQtyType getOrderingQty() {
        return orderingQty;
    }

    /** 
     * Set the 'OrderingQty' element value. Minimum/Maximum Option Ordering Quantities.
     * 
     * @param orderingQty
     */
    public void setOrderingQty(OrderingQtyType orderingQty) {
        this.orderingQty = orderingQty;
    }

    /** 
     * Get the 'TermID' element value. Unique identifier associated to a term instance.
     * 
     * @return value
     */
    public String getTermID() {
        return termID;
    }

    /** 
     * Set the 'TermID' element value. Unique identifier associated to a term instance.
     * 
     * @param termID
     */
    public void setTermID(String termID) {
        this.termID = termID;
    }
}
