
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * The accountable document issued by or on behalf of a carrier which includes notices and the flight and passenger coupons contained therein.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:decimal" name="ConnectedDocNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CouponType" name="Coupon" minOccurs="1" maxOccurs="4"/>
 *     &lt;xs:element type="xs:boolean" name="ExchReissueInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FeeOwnerCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="PresentCreditCardInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="PrimaryDocInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RemarkText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ReportingTypeCodeContentType" name="ReportingTypeCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RoutingCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="TaxOnEMD_Ind" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TicketDocTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TicketNumber" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketType implements Serializable
{
    private BigDecimal connectedDocNumber;
    private List<CouponType> couponList = new ArrayList<CouponType>();
    private Boolean exchReissueInd;
    private String feeOwnerCode;
    private Boolean presentCreditCardInd;
    private Boolean primaryDocInd;
    private String remarkText;
    private ReportingTypeCodeContentType reportingTypeCode;
    private String routingCode;
    private Boolean taxOnEMDInd;
    private String ticketDocTypeCode;
    private String ticketNumber;

    /** 
     * Get the 'ConnectedDocNumber' element value. The ticket/ document number to which this document is connected.
     * 
     * @return value
     */
    public BigDecimal getConnectedDocNumber() {
        return connectedDocNumber;
    }

    /** 
     * Set the 'ConnectedDocNumber' element value. The ticket/ document number to which this document is connected.
     * 
     * @param connectedDocNumber
     */
    public void setConnectedDocNumber(BigDecimal connectedDocNumber) {
        this.connectedDocNumber = connectedDocNumber;
    }

    /** 
     * Get the list of 'Coupon' element items. The portion of the Passenger Ticket and Baggage Check or Excess Baggage Ticket that indicates particular places between which the coupon is good for carriage.
     * 
     * @return list
     */
    public List<CouponType> getCouponList() {
        return couponList;
    }

    /** 
     * Set the list of 'Coupon' element items. The portion of the Passenger Ticket and Baggage Check or Excess Baggage Ticket that indicates particular places between which the coupon is good for carriage.
     * 
     * @param list
     */
    public void setCouponList(List<CouponType> list) {
        couponList = list;
    }

    /** 
     * Get the 'ExchReissueInd' element value. When TRUE, the specified ticket/document number is on behalf of a document which has been exchanged or reissued.
     * 
     * @return value
     */
    public Boolean getExchReissueInd() {
        return exchReissueInd;
    }

    /** 
     * Set the 'ExchReissueInd' element value. When TRUE, the specified ticket/document number is on behalf of a document which has been exchanged or reissued.
     * 
     * @param exchReissueInd
     */
    public void setExchReissueInd(Boolean exchReissueInd) {
        this.exchReissueInd = exchReissueInd;
    }

    /** 
     * Get the 'FeeOwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getFeeOwnerCode() {
        return feeOwnerCode;
    }

    /** 
     * Set the 'FeeOwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param feeOwnerCode
     */
    public void setFeeOwnerCode(String feeOwnerCode) {
        this.feeOwnerCode = feeOwnerCode;
    }

    /** 
     * Get the 'PresentCreditCardInd' element value. When TRUE, the credit/debit card used for purchase must be presented.
     * 
     * @return value
     */
    public Boolean getPresentCreditCardInd() {
        return presentCreditCardInd;
    }

    /** 
     * Set the 'PresentCreditCardInd' element value. When TRUE, the credit/debit card used for purchase must be presented.
     * 
     * @param presentCreditCardInd
     */
    public void setPresentCreditCardInd(Boolean presentCreditCardInd) {
        this.presentCreditCardInd = presentCreditCardInd;
    }

    /** 
     * Get the 'PrimaryDocInd' element value. When TRUE, this is the primary ticket/document number.
     * 
     * @return value
     */
    public Boolean getPrimaryDocInd() {
        return primaryDocInd;
    }

    /** 
     * Set the 'PrimaryDocInd' element value. When TRUE, this is the primary ticket/document number.
     * 
     * @param primaryDocInd
     */
    public void setPrimaryDocInd(Boolean primaryDocInd) {
        this.primaryDocInd = primaryDocInd;
    }

    /** 
     * Get the 'RemarkText' element value. Free text to provide further information related to the document.
     * 
     * @return value
     */
    public String getRemarkText() {
        return remarkText;
    }

    /** 
     * Set the 'RemarkText' element value. Free text to provide further information related to the document.
     * 
     * @param remarkText
     */
    public void setRemarkText(String remarkText) {
        this.remarkText = remarkText;
    }

    /** 
     * Get the 'ReportingTypeCode' element value. For billing and settlement purposes, each time a travel agent requests an airline to perform an action on a document (Issuance, Refund, Exchange), he needs to know how to reconcile this action (via BSP, ARC, directly by ORA, etc.).
     * 
     * @return value
     */
    public ReportingTypeCodeContentType getReportingTypeCode() {
        return reportingTypeCode;
    }

    /** 
     * Set the 'ReportingTypeCode' element value. For billing and settlement purposes, each time a travel agent requests an airline to perform an action on a document (Issuance, Refund, Exchange), he needs to know how to reconcile this action (via BSP, ARC, directly by ORA, etc.).
     * 
     * @param reportingTypeCode
     */
    public void setReportingTypeCode(
            ReportingTypeCodeContentType reportingTypeCode) {
        this.reportingTypeCode = reportingTypeCode;
    }

    /** 
     * Get the 'RoutingCode' element value. For EMD-A and EMD-S tickets with routing.  Use 'D' if all board and off points are within the same country and 'I' if all board and of points are not within the same country.  For EMD-S with no routing, do not use.
     * 
     * @return value
     */
    public String getRoutingCode() {
        return routingCode;
    }

    /** 
     * Set the 'RoutingCode' element value. For EMD-A and EMD-S tickets with routing.  Use 'D' if all board and off points are within the same country and 'I' if all board and of points are not within the same country.  For EMD-S with no routing, do not use.
     * 
     * @param routingCode
     */
    public void setRoutingCode(String routingCode) {
        this.routingCode = routingCode;
    }

    /** 
     * Get the 'TaxOnEMD_Ind' element value. When TRUE, a tax has been collected and is due to a local government from the validating carrier.
     * 
     * @return value
     */
    public Boolean getTaxOnEMDInd() {
        return taxOnEMDInd;
    }

    /** 
     * Set the 'TaxOnEMD_Ind' element value. When TRUE, a tax has been collected and is due to a local government from the validating carrier.
     * 
     * @param taxOnEMDInd
     */
    public void setTaxOnEMDInd(Boolean taxOnEMDInd) {
        this.taxOnEMDInd = taxOnEMDInd;
    }

    /** 
     * Get the 'TicketDocTypeCode' element value. Document type code as defined by PADIS 1001 (Document/ Message Name, coded).
     * 
     * @return value
     */
    public String getTicketDocTypeCode() {
        return ticketDocTypeCode;
    }

    /** 
     * Set the 'TicketDocTypeCode' element value. Document type code as defined by PADIS 1001 (Document/ Message Name, coded).
     * 
     * @param ticketDocTypeCode
     */
    public void setTicketDocTypeCode(String ticketDocTypeCode) {
        this.ticketDocTypeCode = ticketDocTypeCode;
    }

    /** 
     * Get the 'TicketNumber' element value. The document number comprised of the airline code, form code, and serial number.
     * 
     * @return value
     */
    public String getTicketNumber() {
        return ticketNumber;
    }

    /** 
     * Set the 'TicketNumber' element value. The document number comprised of the airline code, form code, and serial number.
     * 
     * @param ticketNumber
     */
    public void setTicketNumber(String ticketNumber) {
        this.ticketNumber = ticketNumber;
    }
}
