
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rs;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderViewRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelAgencyType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AgencyID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ContactInfoRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:decimal" name="IATA_Number" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PseudoCityID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TravelAgentType" name="TravelAgent" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TravelAgencyTypeCodeContentType" name="TypeCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelAgencyType implements Serializable
{
    private String agencyID;
    private List<String> contactInfoRefIDList = new ArrayList<String>();
    private BigDecimal IATANumber;
    private String name;
    private String pseudoCityID;
    private TravelAgentType travelAgent;
    private TravelAgencyTypeCodeContentType typeCode;

    /** 
     * Get the 'AgencyID' element value. Unique Agency Seller ID. Example: CTRV
     * 
     * @return value
     */
    public String getAgencyID() {
        return agencyID;
    }

    /** 
     * Set the 'AgencyID' element value. Unique Agency Seller ID. Example: CTRV
     * 
     * @param agencyID
     */
    public void setAgencyID(String agencyID) {
        this.agencyID = agencyID;
    }

    /** 
     * Get the list of 'ContactInfoRefID' element items. Reference to a ContactInfoRefID.
     * 
     * @return list
     */
    public List<String> getContactInfoRefIDList() {
        return contactInfoRefIDList;
    }

    /** 
     * Set the list of 'ContactInfoRefID' element items. Reference to a ContactInfoRefID.
     * 
     * @param list
     */
    public void setContactInfoRefIDList(List<String> list) {
        contactInfoRefIDList = list;
    }

    /** 
     * Get the 'IATA_Number' element value. IATA-assigned agency number.  Example: 98417900
     * 
     * @return value
     */
    public BigDecimal getIATANumber() {
        return IATANumber;
    }

    /** 
     * Set the 'IATA_Number' element value. IATA-assigned agency number.  Example: 98417900
     * 
     * @param IATANumber
     */
    public void setIATANumber(BigDecimal IATANumber) {
        this.IATANumber = IATANumber;
    }

    /** 
     * Get the 'Name' element value. Agency name.  Example: Carson Travel
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Agency name.  Example: Carson Travel
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'PseudoCityID' element value. An identifier for a corporate user of a computer reservation system (CRS) or global distribution system (GDS), typically a travel agency. Also known as Office ID.
     * 
     * @return value
     */
    public String getPseudoCityID() {
        return pseudoCityID;
    }

    /** 
     * Set the 'PseudoCityID' element value. An identifier for a corporate user of a computer reservation system (CRS) or global distribution system (GDS), typically a travel agency. Also known as Office ID.
     * 
     * @param pseudoCityID
     */
    public void setPseudoCityID(String pseudoCityID) {
        this.pseudoCityID = pseudoCityID;
    }

    /** 
     * Get the 'TravelAgent' element value. A private retailer or public service individual that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @return value
     */
    public TravelAgentType getTravelAgent() {
        return travelAgent;
    }

    /** 
     * Set the 'TravelAgent' element value. A private retailer or public service individual that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @param travelAgent
     */
    public void setTravelAgent(TravelAgentType travelAgent) {
        this.travelAgent = travelAgent;
    }

    /** 
     * Get the 'TypeCode' element value. Agency type code.  Examples TravelAgency, OnlineTravelAgency, or TravelManagementCompany.
     * 
     * @return value
     */
    public TravelAgencyTypeCodeContentType getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' element value. Agency type code.  Examples TravelAgency, OnlineTravelAgency, or TravelManagementCompany.
     * 
     * @param typeCode
     */
    public void setTypeCode(TravelAgencyTypeCodeContentType typeCode) {
        this.typeCode = typeCode;
    }
}
