
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Departure information for affinity shopping requests.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AffinityDepRequestType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CountryType" name="Country" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CountrySubDivisionType" name="CountrySubDivision" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="Date" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MeasureType" name="ProximityDistanceMeasure" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:StationType" name="Station" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="Time" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AffinityDepRequestType implements Serializable
{
    private CountryType country;
    private CountrySubDivisionType countrySubDivision;
    private Date date;
    private MeasureType proximityDistanceMeasure;
    private StationType station;
    private java.util.Date time;

    /** 
     * Get the 'Country' element value. A nation with its own government, occupying a particular territory.
     * 
     * @return value
     */
    public CountryType getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value. A nation with its own government, occupying a particular territory.
     * 
     * @param country
     */
    public void setCountry(CountryType country) {
        this.country = country;
    }

    /** 
     * Get the 'CountrySubDivision' element value. An area of land which is a sub-division within a country, such as a state, a county, a canton, a province, etc.
     * 
     * @return value
     */
    public CountrySubDivisionType getCountrySubDivision() {
        return countrySubDivision;
    }

    /** 
     * Set the 'CountrySubDivision' element value. An area of land which is a sub-division within a country, such as a state, a county, a canton, a province, etc.
     * 
     * @param countrySubDivision
     */
    public void setCountrySubDivision(CountrySubDivisionType countrySubDivision) {
        this.countrySubDivision = countrySubDivision;
    }

    /** 
     * Get the 'Date' element value. The customer's requested departure date.
     * 
     * @return value
     */
    public Date getDate() {
        return date;
    }

    /** 
     * Set the 'Date' element value. The customer's requested departure date.
     * 
     * @param date
     */
    public void setDate(Date date) {
        this.date = date;
    }

    /** 
     * Get the 'ProximityDistanceMeasure' element value. Departure information for affinity shopping requests.
     * 
     * @return value
     */
    public MeasureType getProximityDistanceMeasure() {
        return proximityDistanceMeasure;
    }

    /** 
     * Set the 'ProximityDistanceMeasure' element value. Departure information for affinity shopping requests.
     * 
     * @param proximityDistanceMeasure
     */
    public void setProximityDistanceMeasure(MeasureType proximityDistanceMeasure) {
        this.proximityDistanceMeasure = proximityDistanceMeasure;
    }

    /** 
     * Get the 'Station' element value. Location or facility where air or surface transportation originates, stops and/or terminates, and where passengers and/or cargo can be taken on or off.
     * 
     * @return value
     */
    public StationType getStation() {
        return station;
    }

    /** 
     * Set the 'Station' element value. Location or facility where air or surface transportation originates, stops and/or terminates, and where passengers and/or cargo can be taken on or off.
     * 
     * @param station
     */
    public void setStation(StationType station) {
        this.station = station;
    }

    /** 
     * Get the 'Time' element value. The customer's requested departure time.
     * 
     * @return value
     */
    public java.util.Date getTime() {
        return time;
    }

    /** 
     * Set the 'Time' element value. The customer's requested departure time.
     * 
     * @param time
     */
    public void setTime(java.util.Date time) {
        this.time = time;
    }
}
