
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Origin and Destination information for affinity shopping requests.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AffinityOriginDestType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AffinityArrivalRequestType" name="AffinityArrivalRequest" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AffinityDepRequestType" name="AffinityDepRequest" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ConnectionPrefRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CabinTypeType" name="PreferredCabinType" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AffinityOriginDestType implements Serializable
{
    private AffinityArrivalRequestType affinityArrivalRequest;
    private AffinityDepRequestType affinityDepRequest;
    private String connectionPrefRefID;
    private List<CabinTypeType> preferredCabinTypeList = new ArrayList<CabinTypeType>();

    /** 
     * Get the 'AffinityArrivalRequest' element value. Arrival information for affinity shopping requests.
     * 
     * @return value
     */
    public AffinityArrivalRequestType getAffinityArrivalRequest() {
        return affinityArrivalRequest;
    }

    /** 
     * Set the 'AffinityArrivalRequest' element value. Arrival information for affinity shopping requests.
     * 
     * @param affinityArrivalRequest
     */
    public void setAffinityArrivalRequest(
            AffinityArrivalRequestType affinityArrivalRequest) {
        this.affinityArrivalRequest = affinityArrivalRequest;
    }

    /** 
     * Get the 'AffinityDepRequest' element value. Departure information for affinity shopping requests.
     * 
     * @return value
     */
    public AffinityDepRequestType getAffinityDepRequest() {
        return affinityDepRequest;
    }

    /** 
     * Set the 'AffinityDepRequest' element value. Departure information for affinity shopping requests.
     * 
     * @param affinityDepRequest
     */
    public void setAffinityDepRequest(AffinityDepRequestType affinityDepRequest) {
        this.affinityDepRequest = affinityDepRequest;
    }

    /** 
     * Get the 'ConnectionPrefRefID' element value. Reference to a transfer preference ID.
     * 
     * @return value
     */
    public String getConnectionPrefRefID() {
        return connectionPrefRefID;
    }

    /** 
     * Set the 'ConnectionPrefRefID' element value. Reference to a transfer preference ID.
     * 
     * @param connectionPrefRefID
     */
    public void setConnectionPrefRefID(String connectionPrefRefID) {
        this.connectionPrefRefID = connectionPrefRefID;
    }

    /** 
     * Get the list of 'PreferredCabinType' element items. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @return list
     */
    public List<CabinTypeType> getPreferredCabinTypeList() {
        return preferredCabinTypeList;
    }

    /** 
     * Set the list of 'PreferredCabinType' element items. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @param list
     */
    public void setPreferredCabinTypeList(List<CabinTypeType> list) {
        preferredCabinTypeList = list;
    }
}
