
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Affinity search includes a wide range of criteria including generic origin/destination information, trip time periods, as well as travel budget.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AffinityShoppingCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AffinityOriginDestType" name="AffinityOriginDest" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AmountType" name="BudgetAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:JourneyDistanceCriteriaType" name="JourneyDistanceCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:JourneyDurationCriteriaType" name="JourneyDurationCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:KeyValuePropertyType" name="KeywordPref" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ShoppingResponseType" name="ShoppingResponse" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:StayPeriodType" name="StayPeriod" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AffinityShoppingCriteriaType implements Serializable
{
    private List<AffinityOriginDestType> affinityOriginDestList = new ArrayList<AffinityOriginDestType>();
    private AmountType budgetAmount;
    private JourneyDistanceCriteriaType journeyDistanceCriteria;
    private JourneyDurationCriteriaType journeyDurationCriteria;
    private List<KeyValuePropertyType> keywordPrefList = new ArrayList<KeyValuePropertyType>();
    private ShoppingResponseType shoppingResponse;
    private StayPeriodType stayPeriod;

    /** 
     * Get the list of 'AffinityOriginDest' element items. Origin and Destination information for affinity shopping requests.
     * 
     * @return list
     */
    public List<AffinityOriginDestType> getAffinityOriginDestList() {
        return affinityOriginDestList;
    }

    /** 
     * Set the list of 'AffinityOriginDest' element items. Origin and Destination information for affinity shopping requests.
     * 
     * @param list
     */
    public void setAffinityOriginDestList(List<AffinityOriginDestType> list) {
        affinityOriginDestList = list;
    }

    /** 
     * Get the 'BudgetAmount' element value. Total budget for all Passengers (Payers) for a journey request.
     * 
     * @return value
     */
    public AmountType getBudgetAmount() {
        return budgetAmount;
    }

    /** 
     * Set the 'BudgetAmount' element value. Total budget for all Passengers (Payers) for a journey request.
     * 
     * @param budgetAmount
     */
    public void setBudgetAmount(AmountType budgetAmount) {
        this.budgetAmount = budgetAmount;
    }

    /** 
     * Get the 'JourneyDistanceCriteria' element value. Total journey distance criteria.
     * 
     * @return value
     */
    public JourneyDistanceCriteriaType getJourneyDistanceCriteria() {
        return journeyDistanceCriteria;
    }

    /** 
     * Set the 'JourneyDistanceCriteria' element value. Total journey distance criteria.
     * 
     * @param journeyDistanceCriteria
     */
    public void setJourneyDistanceCriteria(
            JourneyDistanceCriteriaType journeyDistanceCriteria) {
        this.journeyDistanceCriteria = journeyDistanceCriteria;
    }

    /** 
     * Get the 'JourneyDurationCriteria' element value. Total journey travel time preferences.  This includes the sum of all flight durations as well as connection times.
     * 
     * @return value
     */
    public JourneyDurationCriteriaType getJourneyDurationCriteria() {
        return journeyDurationCriteria;
    }

    /** 
     * Set the 'JourneyDurationCriteria' element value. Total journey travel time preferences.  This includes the sum of all flight durations as well as connection times.
     * 
     * @param journeyDurationCriteria
     */
    public void setJourneyDurationCriteria(
            JourneyDurationCriteriaType journeyDurationCriteria) {
        this.journeyDurationCriteria = journeyDurationCriteria;
    }

    /** 
     * Get the list of 'KeywordPref' element items. Contextual information to further describe something using a key-value pair.
     * 
     * @return list
     */
    public List<KeyValuePropertyType> getKeywordPrefList() {
        return keywordPrefList;
    }

    /** 
     * Set the list of 'KeywordPref' element items. Contextual information to further describe something using a key-value pair.
     * 
     * @param list
     */
    public void setKeywordPrefList(List<KeyValuePropertyType> list) {
        keywordPrefList = list;
    }

    /** 
     * Get the 'ShoppingResponse' element value. Shopping session (message response) ID.
     * 
     * @return value
     */
    public ShoppingResponseType getShoppingResponse() {
        return shoppingResponse;
    }

    /** 
     * Set the 'ShoppingResponse' element value. Shopping session (message response) ID.
     * 
     * @param shoppingResponse
     */
    public void setShoppingResponse(ShoppingResponseType shoppingResponse) {
        this.shoppingResponse = shoppingResponse;
    }

    /** 
     * Get the 'StayPeriod' element value. Time constraints for an Affinity Shopping request including specific Dates, Seasons, Months, or Durations.
     * 
     * @return value
     */
    public StayPeriodType getStayPeriod() {
        return stayPeriod;
    }

    /** 
     * Set the 'StayPeriod' element value. Time constraints for an Affinity Shopping request including specific Dates, Seasons, Months, or Durations.
     * 
     * @param stayPeriod
     */
    public void setStayPeriod(StayPeriodType stayPeriod) {
        this.stayPeriod = stayPeriod;
    }
}
