
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Any machine that can derive support in the atmosphere from the reactions of the air other than the reactions of the air against the earthâ€™s surface. It must be certified as airworthy by a competent aeronautical authority.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AircraftType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AircraftRegistrationID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TailNumberText" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AircraftType implements Serializable
{
    private String aircraftRegistrationID;
    private String tailNumberText;

    /** 
     * Get the 'AircraftRegistrationID' element value. The complete alphanumeric identification assigned by the appropriate licensing authority to an individual aircraft. Hyphens contained within the registration shall not be included. E.g. GBOAC, N46573, ZZ123.
     * 
     * @return value
     */
    public String getAircraftRegistrationID() {
        return aircraftRegistrationID;
    }

    /** 
     * Set the 'AircraftRegistrationID' element value. The complete alphanumeric identification assigned by the appropriate licensing authority to an individual aircraft. Hyphens contained within the registration shall not be included. E.g. GBOAC, N46573, ZZ123.
     * 
     * @param aircraftRegistrationID
     */
    public void setAircraftRegistrationID(String aircraftRegistrationID) {
        this.aircraftRegistrationID = aircraftRegistrationID;
    }

    /** 
     * Get the 'TailNumberText' element value. Abbreviated version of the unique aircraft registration code, such as without country code. Also called 'Tail Number'
     * 
     * @return value
     */
    public String getTailNumberText() {
        return tailNumberText;
    }

    /** 
     * Set the 'TailNumberText' element value. Abbreviated version of the unique aircraft registration code, such as without country code. Also called 'Tail Number'
     * 
     * @param tailNumberText
     */
    public void setTailNumberText(String tailNumberText) {
        this.tailNumberText = tailNumberText;
    }
}
