
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Filtering criteria based on Alliance.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AllianceCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AllianceType" name="Alliance" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FlightHaulTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="GeographicalIndTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PrefLevelType" name="PrefLevel" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AllianceCriteriaType implements Serializable
{
    private AllianceType alliance;
    private String flightHaulTypeCode;
    private String geographicalIndTypeCode;
    private PrefLevelType prefLevel;

    /** 
     * Get the 'Alliance' element value. Two or more airlines participating in a commercial relationship or joint venture, where a joint and commonly identifiable product is marketed under a single commercial name or brand.
     * 
     * @return value
     */
    public AllianceType getAlliance() {
        return alliance;
    }

    /** 
     * Set the 'Alliance' element value. Two or more airlines participating in a commercial relationship or joint venture, where a joint and commonly identifiable product is marketed under a single commercial name or brand.
     * 
     * @param alliance
     */
    public void setAlliance(AllianceType alliance) {
        this.alliance = alliance;
    }

    /** 
     * Get the 'FlightHaulTypeCode' element value. Flight haul length type.  Example: LH (long haul 6 hrs plus).
     * 
     * @return value
     */
    public String getFlightHaulTypeCode() {
        return flightHaulTypeCode;
    }

    /** 
     * Set the 'FlightHaulTypeCode' element value. Flight haul length type.  Example: LH (long haul 6 hrs plus).
     * 
     * @param flightHaulTypeCode
     */
    public void setFlightHaulTypeCode(String flightHaulTypeCode) {
        this.flightHaulTypeCode = flightHaulTypeCode;
    }

    /** 
     * Get the 'GeographicalIndTypeCode' element value. Geographical indicator type.  Example: DOM (Domestic)
     * 
     * @return value
     */
    public String getGeographicalIndTypeCode() {
        return geographicalIndTypeCode;
    }

    /** 
     * Set the 'GeographicalIndTypeCode' element value. Geographical indicator type.  Example: DOM (Domestic)
     * 
     * @param geographicalIndTypeCode
     */
    public void setGeographicalIndTypeCode(String geographicalIndTypeCode) {
        this.geographicalIndTypeCode = geographicalIndTypeCode;
    }

    /** 
     * Get the 'PrefLevel' element value. Information supporting a preference including preference level code (e.g. Preferred, Exclude, etc.).
     * 
     * @return value
     */
    public PrefLevelType getPrefLevel() {
        return prefLevel;
    }

    /** 
     * Set the 'PrefLevel' element value. Information supporting a preference including preference level code (e.g. Preferred, Exclude, etc.).
     * 
     * @param prefLevel
     */
    public void setPrefLevel(PrefLevelType prefLevel) {
        this.prefLevel = prefLevel;
    }
}
