
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Requests the airline to additionally include a preview of the Offer price for the same Shopping Criteria for the specified date range.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CalendarDateCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:decimal" name="DaysAfterNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="DaysBeforeNumber" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CalendarDateCriteriaType implements Serializable
{
    private BigDecimal daysAfterNumber;
    private BigDecimal daysBeforeNumber;

    /** 
     * Get the 'DaysAfterNumber' element value. Number of days after the Departure and Arrival dates for which the Calendar Date request should consider.
     * 
     * @return value
     */
    public BigDecimal getDaysAfterNumber() {
        return daysAfterNumber;
    }

    /** 
     * Set the 'DaysAfterNumber' element value. Number of days after the Departure and Arrival dates for which the Calendar Date request should consider.
     * 
     * @param daysAfterNumber
     */
    public void setDaysAfterNumber(BigDecimal daysAfterNumber) {
        this.daysAfterNumber = daysAfterNumber;
    }

    /** 
     * Get the 'DaysBeforeNumber' element value. Number of days prior to the Departure and Arrival dates for which the Calendar Date request should consider.
     * 
     * @return value
     */
    public BigDecimal getDaysBeforeNumber() {
        return daysBeforeNumber;
    }

    /** 
     * Set the 'DaysBeforeNumber' element value. Number of days prior to the Departure and Arrival dates for which the Calendar Date request should consider.
     * 
     * @param daysBeforeNumber
     */
    public void setDaysBeforeNumber(BigDecimal daysBeforeNumber) {
        this.daysBeforeNumber = daysBeforeNumber;
    }
}
