
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Airline preferences for a shopping request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarrierCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CarrierType" name="Carrier" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FlightHaulTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="GeographicalIndTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PrefLevelType" name="PrefLevel" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CarrierCriteriaType implements Serializable
{
    private CarrierType carrier;
    private String flightHaulTypeCode;
    private String geographicalIndTypeCode;
    private PrefLevelType prefLevel;

    /** 
     * Get the 'Carrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return value
     */
    public CarrierType getCarrier() {
        return carrier;
    }

    /** 
     * Set the 'Carrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param carrier
     */
    public void setCarrier(CarrierType carrier) {
        this.carrier = carrier;
    }

    /** 
     * Get the 'FlightHaulTypeCode' element value. Flight haul length type.  Example: LH (long haul 6 hrs plus).
     * 
     * @return value
     */
    public String getFlightHaulTypeCode() {
        return flightHaulTypeCode;
    }

    /** 
     * Set the 'FlightHaulTypeCode' element value. Flight haul length type.  Example: LH (long haul 6 hrs plus).
     * 
     * @param flightHaulTypeCode
     */
    public void setFlightHaulTypeCode(String flightHaulTypeCode) {
        this.flightHaulTypeCode = flightHaulTypeCode;
    }

    /** 
     * Get the 'GeographicalIndTypeCode' element value. Geographical indicator type.  Example: DOM (Domestic)
     * 
     * @return value
     */
    public String getGeographicalIndTypeCode() {
        return geographicalIndTypeCode;
    }

    /** 
     * Set the 'GeographicalIndTypeCode' element value. Geographical indicator type.  Example: DOM (Domestic)
     * 
     * @param geographicalIndTypeCode
     */
    public void setGeographicalIndTypeCode(String geographicalIndTypeCode) {
        this.geographicalIndTypeCode = geographicalIndTypeCode;
    }

    /** 
     * Get the 'PrefLevel' element value. Information supporting a preference including preference level code (e.g. Preferred, Exclude, etc.).
     * 
     * @return value
     */
    public PrefLevelType getPrefLevel() {
        return prefLevel;
    }

    /** 
     * Set the 'PrefLevel' element value. Information supporting a preference including preference level code (e.g. Preferred, Exclude, etc.).
     * 
     * @param prefLevel
     */
    public void setPrefLevel(PrefLevelType prefLevel) {
        this.prefLevel = prefLevel;
    }
}
