
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * An operation between board point and any subsequent off point within the same flight designator. Could be one or more legs. Could also be used for other transport vehicles such as train or bus etc.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DatedOperatingSegmentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CarrierDesigCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CarrierName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Duration" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OperatingCarrierFlightNumberText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OperationalSuffixText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RBD_Code" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="SecureFlightInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SegmentTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="StatusCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DatedOperatingSegmentType implements Serializable
{
    private String carrierDesigCode;
    private String carrierName;
    private String duration;
    private String operatingCarrierFlightNumberText;
    private String operationalSuffixText;
    private String RBDCode;
    private Boolean secureFlightInd;
    private String segmentTypeCode;
    private String statusCode;

    /** 
     * Get the 'CarrierDesigCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getCarrierDesigCode() {
        return carrierDesigCode;
    }

    /** 
     * Set the 'CarrierDesigCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param carrierDesigCode
     */
    public void setCarrierDesigCode(String carrierDesigCode) {
        this.carrierDesigCode = carrierDesigCode;
    }

    /** 
     * Get the 'CarrierName' element value. Commercial name of the carrier.
     * 
     * @return value
     */
    public String getCarrierName() {
        return carrierName;
    }

    /** 
     * Set the 'CarrierName' element value. Commercial name of the carrier.
     * 
     * @param carrierName
     */
    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    /** 
     * Get the 'Duration' element value. Total segment time including the combined air time and connection times of any legs.
     * 
     * @return value
     */
    public String getDuration() {
        return duration;
    }

    /** 
     * Set the 'Duration' element value. Total segment time including the combined air time and connection times of any legs.
     * 
     * @param duration
     */
    public void setDuration(String duration) {
        this.duration = duration;
    }

    /** 
     * Get the 'OperatingCarrierFlightNumberText' element value. The numerical designation of a flight as it is operated by a carrier.
     * 
     * @return value
     */
    public String getOperatingCarrierFlightNumberText() {
        return operatingCarrierFlightNumberText;
    }

    /** 
     * Set the 'OperatingCarrierFlightNumberText' element value. The numerical designation of a flight as it is operated by a carrier.
     * 
     * @param operatingCarrierFlightNumberText
     */
    public void setOperatingCarrierFlightNumberText(
            String operatingCarrierFlightNumberText) {
        this.operatingCarrierFlightNumberText = operatingCarrierFlightNumberText;
    }

    /** 
     * Get the 'OperationalSuffixText' element value. Used to distinguish two flights having the same flight number and departing from their respective Origin Stations on the same date.
     * 
     * @return value
     */
    public String getOperationalSuffixText() {
        return operationalSuffixText;
    }

    /** 
     * Set the 'OperationalSuffixText' element value. Used to distinguish two flights having the same flight number and departing from their respective Origin Stations on the same date.
     * 
     * @param operationalSuffixText
     */
    public void setOperationalSuffixText(String operationalSuffixText) {
        this.operationalSuffixText = operationalSuffixText;
    }

    /** 
     * Get the 'RBD_Code' element value. Code used to identify a particular RBD (e.g. P, J, W, M, etc.).
     * 
     * @return value
     */
    public String getRBDCode() {
        return RBDCode;
    }

    /** 
     * Set the 'RBD_Code' element value. Code used to identify a particular RBD (e.g. P, J, W, M, etc.).
     * 
     * @param RBDCode
     */
    public void setRBDCode(String RBDCode) {
        this.RBDCode = RBDCode;
    }

    /** 
     * Get the 'SecureFlightInd' element value. When TRUE, this segment is subject to US TSA 'Secure Flight' passenger prescreening program.
     * 
     * @return value
     */
    public Boolean getSecureFlightInd() {
        return secureFlightInd;
    }

    /** 
     * Set the 'SecureFlightInd' element value. When TRUE, this segment is subject to US TSA 'Secure Flight' passenger prescreening program.
     * 
     * @param secureFlightInd
     */
    public void setSecureFlightInd(Boolean secureFlightInd) {
        this.secureFlightInd = secureFlightInd;
    }

    /** 
     * Get the 'SegmentTypeCode' element value. Defines the operational flight segment type (e.g. Open, Passive, Service).  Encoding Scheme: IATA PADIS 1.4 Codeset FST - Flight Segment Type
     * 
     * @return value
     */
    public String getSegmentTypeCode() {
        return segmentTypeCode;
    }

    /** 
     * Set the 'SegmentTypeCode' element value. Defines the operational flight segment type (e.g. Open, Passive, Service).  Encoding Scheme: IATA PADIS 1.4 Codeset FST - Flight Segment Type
     * 
     * @param segmentTypeCode
     */
    public void setSegmentTypeCode(String segmentTypeCode) {
        this.segmentTypeCode = segmentTypeCode;
    }

    /** 
     * Get the 'StatusCode' element value. Flight Status, examples: SO, Flight Canceled.  Refer PADIS codeset  1245.
     * 
     * @return value
     */
    public String getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' element value. Flight Status, examples: SO, Flight Canceled.  Refer PADIS codeset  1245.
     * 
     * @param statusCode
     */
    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }
}
