
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Function to request the removal of Order Items from this specific Order.  If used alone (without a shopping query from the â€œAddâ€&#157; function), the RS will assume a cancellation is desired for the Order Items specified and will return incurred fees/refund
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeleteOrderItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OrderItemRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RetainServiceID" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DeleteOrderItemType implements Serializable
{
    private String orderItemRefID;
    private List<String> retainServiceIDList = new ArrayList<String>();

    /** 
     * Get the 'OrderItemRefID' element value. Reference to the Order Item requested for deletion.
     * 
     * @return value
     */
    public String getOrderItemRefID() {
        return orderItemRefID;
    }

    /** 
     * Set the 'OrderItemRefID' element value. Reference to the Order Item requested for deletion.
     * 
     * @param orderItemRefID
     */
    public void setOrderItemRefID(String orderItemRefID) {
        this.orderItemRefID = orderItemRefID;
    }

    /** 
     * Get the list of 'RetainServiceID' element items. Reference to the Service within the specified Order Item which the Passenger would like the Airline to retain and return within the proposed Offer Item(s) in the OrderReshopRS.
     * 
     * @return list
     */
    public List<String> getRetainServiceIDList() {
        return retainServiceIDList;
    }

    /** 
     * Set the list of 'RetainServiceID' element items. Reference to the Service within the specified Order Item which the Passenger would like the Airline to retain and return within the proposed Offer Item(s) in the OrderReshopRS.
     * 
     * @param list
     */
    public void setRetainServiceIDList(List<String> list) {
        retainServiceIDList = list;
    }
}
