
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * References to Orders that were created from Offers that have already been purchased, booked and/or are being held for a Passenger.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExistingOrderCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:OrderType" name="Order" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxRefID" minOccurs="1" maxOccurs="99"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ExistingOrderCriteriaType implements Serializable
{
    private OrderType order;
    private List<String> paxRefIDList = new ArrayList<String>();

    /** 
     * Get the 'Order' element value. A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not necessarily Journey based (e.g. subscription services).
     * 
     * @return value
     */
    public OrderType getOrder() {
        return order;
    }

    /** 
     * Set the 'Order' element value. A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not necessarily Journey based (e.g. subscription services).
     * 
     * @param order
     */
    public void setOrder(OrderType order) {
        this.order = order;
    }

    /** 
     * Get the list of 'PaxRefID' element items. Reference to a Passenger ID within this message.
     * 
     * @return list
     */
    public List<String> getPaxRefIDList() {
        return paxRefIDList;
    }

    /** 
     * Set the list of 'PaxRefID' element items. Reference to a Passenger ID within this message.
     * 
     * @param list
     */
    public void setPaxRefIDList(List<String> list) {
        paxRefIDList = list;
    }
}
