
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Flight filter criteria including aircraft features, Cabin Type, RBD, and Tail Number.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AircraftType" name="Aircraft" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:CabinTypeType" name="CabinType" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:FlightCharacteristicsCriteriaType" name="FlightCharacteristicsCriteria" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:IATA_AircraftTypeType" name="IATA_AircraftType" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:RBD_Type" name="RBD" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PrefLevelType" name="WaitListCriteria" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightCriteriaType implements Serializable
{
    private List<AircraftType> aircraftList = new ArrayList<AircraftType>();
    private List<CabinTypeType> cabinTypeList = new ArrayList<CabinTypeType>();
    private List<FlightCharacteristicsCriteriaType> flightCharacteristicsCriteriaList = new ArrayList<FlightCharacteristicsCriteriaType>();
    private List<IATAAircraftTypeType> IATAAircraftTypeList = new ArrayList<IATAAircraftTypeType>();
    private List<RBDType> RBDList = new ArrayList<RBDType>();
    private PrefLevelType waitListCriteria;

    /** 
     * Get the list of 'Aircraft' element items. Any machine that can derive support in the atmosphere from the reactions of the air other than the reactions of the air against the earthâ€™s surface. It must be certified as airworthy by a competent aeronautical authority.
     * 
     * @return list
     */
    public List<AircraftType> getAircraftList() {
        return aircraftList;
    }

    /** 
     * Set the list of 'Aircraft' element items. Any machine that can derive support in the atmosphere from the reactions of the air other than the reactions of the air against the earthâ€™s surface. It must be certified as airworthy by a competent aeronautical authority.
     * 
     * @param list
     */
    public void setAircraftList(List<AircraftType> list) {
        aircraftList = list;
    }

    /** 
     * Get the list of 'CabinType' element items. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @return list
     */
    public List<CabinTypeType> getCabinTypeList() {
        return cabinTypeList;
    }

    /** 
     * Set the list of 'CabinType' element items. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @param list
     */
    public void setCabinTypeList(List<CabinTypeType> list) {
        cabinTypeList = list;
    }

    /** 
     * Get the list of 'FlightCharacteristicsCriteria' element items. Flight characteristics filter criteria for shopping requests, including non-stop, red eye, etc.
     * 
     * @return list
     */
    public List<FlightCharacteristicsCriteriaType> getFlightCharacteristicsCriteriaList() {
        return flightCharacteristicsCriteriaList;
    }

    /** 
     * Set the list of 'FlightCharacteristicsCriteria' element items. Flight characteristics filter criteria for shopping requests, including non-stop, red eye, etc.
     * 
     * @param list
     */
    public void setFlightCharacteristicsCriteriaList(
            List<FlightCharacteristicsCriteriaType> list) {
        flightCharacteristicsCriteriaList = list;
    }

    /** 
     * Get the list of 'IATA_AircraftType' element items. Grouping of aircrafts with the same form, function and specification, currently flown, or soon to be flown. Possible types are defined in the IATA SSIM.
     * 
     * @return list
     */
    public List<IATAAircraftTypeType> getIATAAircraftTypeList() {
        return IATAAircraftTypeList;
    }

    /** 
     * Set the list of 'IATA_AircraftType' element items. Grouping of aircrafts with the same form, function and specification, currently flown, or soon to be flown. Possible types are defined in the IATA SSIM.
     * 
     * @param list
     */
    public void setIATAAircraftTypeList(List<IATAAircraftTypeType> list) {
        IATAAircraftTypeList = list;
    }

    /** 
     * Get the list of 'RBD' element items. Reservation Booking Designator.  A categorization used to facilitate access to inventory, application of filed fares, and to identify cabin entitlement. Identified using a single alpha character. E.g. 'J' for Business Class Premium, 'D' for Business Discounted.
     * 
     * @return list
     */
    public List<RBDType> getRBDList() {
        return RBDList;
    }

    /** 
     * Set the list of 'RBD' element items. Reservation Booking Designator.  A categorization used to facilitate access to inventory, application of filed fares, and to identify cabin entitlement. Identified using a single alpha character. E.g. 'J' for Business Class Premium, 'D' for Business Discounted.
     * 
     * @param list
     */
    public void setRBDList(List<RBDType> list) {
        RBDList = list;
    }

    /** 
     * Get the 'WaitListCriteria' element value. Wait listing shopping preference information.
     * 
     * @return value
     */
    public PrefLevelType getWaitListCriteria() {
        return waitListCriteria;
    }

    /** 
     * Set the 'WaitListCriteria' element value. Wait listing shopping preference information.
     * 
     * @param waitListCriteria
     */
    public void setWaitListCriteria(PrefLevelType waitListCriteria) {
        this.waitListCriteria = waitListCriteria;
    }
}
