
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Choice of Affinity, Origin Destination, or Journey flight information for this shopping request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightRequestType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:AffinityShoppingCriteriaType" name="AffinityShoppingCriteria" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OriginDestCriteriaType" name="OriginDestCriteria" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ShoppingResponseType" name="ShoppingResponse" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OriginDestType" name="SpecificOriginDestCriteria" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightRequestType implements Serializable
{
    private int choiceSelect = -1;
    private static final int AFFINITY_SHOPPING_CRITERIA_CHOICE = 0;
    private static final int ORIGIN_DEST_CRITERIA_LIST_CHOICE = 1;
    private static final int SHOPPING_RESPONSE_CHOICE = 2;
    private static final int SPECIFIC_ORIGIN_DEST_CRITERIA_LIST_CHOICE = 3;
    private AffinityShoppingCriteriaType affinityShoppingCriteria;
    private List<OriginDestCriteriaType> originDestCriteriaList = new ArrayList<OriginDestCriteriaType>();
    private ShoppingResponseType shoppingResponse;
    private List<OriginDestType> specificOriginDestCriteriaList = new ArrayList<OriginDestType>();

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AffinityShoppingCriteria is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAffinityShoppingCriteria() {
        return choiceSelect == AFFINITY_SHOPPING_CRITERIA_CHOICE;
    }

    /** 
     * Get the 'AffinityShoppingCriteria' element value. Affinity search includes a wide range of criteria including generic origin/destination information, trip time periods, as well as travel budget.
     * 
     * @return value
     */
    public AffinityShoppingCriteriaType getAffinityShoppingCriteria() {
        return affinityShoppingCriteria;
    }

    /** 
     * Set the 'AffinityShoppingCriteria' element value. Affinity search includes a wide range of criteria including generic origin/destination information, trip time periods, as well as travel budget.
     * 
     * @param affinityShoppingCriteria
     */
    public void setAffinityShoppingCriteria(
            AffinityShoppingCriteriaType affinityShoppingCriteria) {
        setChoiceSelect(AFFINITY_SHOPPING_CRITERIA_CHOICE);
        this.affinityShoppingCriteria = affinityShoppingCriteria;
    }

    /** 
     * Check if OriginDestCriteriaList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOriginDestCriteriaList() {
        return choiceSelect == ORIGIN_DEST_CRITERIA_LIST_CHOICE;
    }

    /** 
     * Get the list of 'OriginDestCriteria' element items. The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight.
     * 
     * @return list
     */
    public List<OriginDestCriteriaType> getOriginDestCriteriaList() {
        return originDestCriteriaList;
    }

    /** 
     * Set the list of 'OriginDestCriteria' element items. The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight.
     * 
     * @param list
     */
    public void setOriginDestCriteriaList(List<OriginDestCriteriaType> list) {
        setChoiceSelect(ORIGIN_DEST_CRITERIA_LIST_CHOICE);
        originDestCriteriaList = list;
    }

    /** 
     * Check if ShoppingResponse is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifShoppingResponse() {
        return choiceSelect == SHOPPING_RESPONSE_CHOICE;
    }

    /** 
     * Get the 'ShoppingResponse' element value. Shopping session (message response) ID.
     * 
     * @return value
     */
    public ShoppingResponseType getShoppingResponse() {
        return shoppingResponse;
    }

    /** 
     * Set the 'ShoppingResponse' element value. Shopping session (message response) ID.
     * 
     * @param shoppingResponse
     */
    public void setShoppingResponse(ShoppingResponseType shoppingResponse) {
        setChoiceSelect(SHOPPING_RESPONSE_CHOICE);
        this.shoppingResponse = shoppingResponse;
    }

    /** 
     * Check if SpecificOriginDestCriteriaList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSpecificOriginDestCriteriaList() {
        return choiceSelect == SPECIFIC_ORIGIN_DEST_CRITERIA_LIST_CHOICE;
    }

    /** 
     * Get the list of 'SpecificOriginDestCriteria' element items. The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight.
     * 
     * @return list
     */
    public List<OriginDestType> getSpecificOriginDestCriteriaList() {
        return specificOriginDestCriteriaList;
    }

    /** 
     * Set the list of 'SpecificOriginDestCriteria' element items. The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight.
     * 
     * @param list
     */
    public void setSpecificOriginDestCriteriaList(List<OriginDestType> list) {
        setChoiceSelect(SPECIFIC_ORIGIN_DEST_CRITERIA_LIST_CHOICE);
        specificOriginDestCriteriaList = list;
    }
}
