
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * A location with a spatial attribute, probably on the surface of the earth. For example: Longitude and Latitude
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GeospatialLocationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="NaturalAreaGeocode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="PointElevationNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="PointLatitudeNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="PointLongitudeNumber" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GeospatialLocationType implements Serializable
{
    private String naturalAreaGeocode;
    private BigDecimal pointElevationNumber;
    private BigDecimal pointLatitudeNumber;
    private BigDecimal pointLongitudeNumber;

    /** 
     * Get the 'NaturalAreaGeocode' element value. Natural Area Geocode as defined by NAC Geographic Products Inc.  Ex: 8KDB PGFD
     * 
     * @return value
     */
    public String getNaturalAreaGeocode() {
        return naturalAreaGeocode;
    }

    /** 
     * Set the 'NaturalAreaGeocode' element value. Natural Area Geocode as defined by NAC Geographic Products Inc.  Ex: 8KDB PGFD
     * 
     * @param naturalAreaGeocode
     */
    public void setNaturalAreaGeocode(String naturalAreaGeocode) {
        this.naturalAreaGeocode = naturalAreaGeocode;
    }

    /** 
     * Get the 'PointElevationNumber' element value. The number of the spatial location point elevation.
     * 
     * @return value
     */
    public BigDecimal getPointElevationNumber() {
        return pointElevationNumber;
    }

    /** 
     * Set the 'PointElevationNumber' element value. The number of the spatial location point elevation.
     * 
     * @param pointElevationNumber
     */
    public void setPointElevationNumber(BigDecimal pointElevationNumber) {
        this.pointElevationNumber = pointElevationNumber;
    }

    /** 
     * Get the 'PointLatitudeNumber' element value. The number of the spatial location point latitude.
     * 
     * @return value
     */
    public BigDecimal getPointLatitudeNumber() {
        return pointLatitudeNumber;
    }

    /** 
     * Set the 'PointLatitudeNumber' element value. The number of the spatial location point latitude.
     * 
     * @param pointLatitudeNumber
     */
    public void setPointLatitudeNumber(BigDecimal pointLatitudeNumber) {
        this.pointLatitudeNumber = pointLatitudeNumber;
    }

    /** 
     * Get the 'PointLongitudeNumber' element value. The number of the spatial location point longitude.
     * 
     * @return value
     */
    public BigDecimal getPointLongitudeNumber() {
        return pointLongitudeNumber;
    }

    /** 
     * Set the 'PointLongitudeNumber' element value. The number of the spatial location point longitude.
     * 
     * @param pointLongitudeNumber
     */
    public void setPointLongitudeNumber(BigDecimal pointLongitudeNumber) {
        this.pointLongitudeNumber = pointLongitudeNumber;
    }
}
