
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Group Fare preferences by passenger type
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GroupFareCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="FareBasisCode" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PaxSegmentRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PrefLevelType" name="PrefLevel" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PTC" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GroupFareCriteriaType implements Serializable
{
    private List<String> fareBasisCodeList = new ArrayList<String>();
    private List<String> paxSegmentRefIDList = new ArrayList<String>();
    private PrefLevelType prefLevel;
    private String PTC;

    /** 
     * Get the list of 'FareBasisCode' element items. Fare basis code. Example: Y26
     * 
     * @return list
     */
    public List<String> getFareBasisCodeList() {
        return fareBasisCodeList;
    }

    /** 
     * Set the list of 'FareBasisCode' element items. Fare basis code. Example: Y26
     * 
     * @param list
     */
    public void setFareBasisCodeList(List<String> list) {
        fareBasisCodeList = list;
    }

    /** 
     * Get the list of 'PaxSegmentRefID' element items. Reference to a Passenger Segment ID.
     * 
     * @return list
     */
    public List<String> getPaxSegmentRefIDList() {
        return paxSegmentRefIDList;
    }

    /** 
     * Set the list of 'PaxSegmentRefID' element items. Reference to a Passenger Segment ID.
     * 
     * @param list
     */
    public void setPaxSegmentRefIDList(List<String> list) {
        paxSegmentRefIDList = list;
    }

    /** 
     * Get the 'PrefLevel' element value. Information supporting a preference including preference level code (e.g. Preferred, Exclude, etc.).
     * 
     * @return value
     */
    public PrefLevelType getPrefLevel() {
        return prefLevel;
    }

    /** 
     * Set the 'PrefLevel' element value. Information supporting a preference including preference level code (e.g. Preferred, Exclude, etc.).
     * 
     * @param prefLevel
     */
    public void setPrefLevel(PrefLevelType prefLevel) {
        this.prefLevel = prefLevel;
    }

    /** 
     * Get the 'PTC' element value. Type code applying to the Passenger which typically drives pricing (e.g. ADT, CHD, etc).
     * 
     * @return value
     */
    public String getPTC() {
        return PTC;
    }

    /** 
     * Set the 'PTC' element value. Type code applying to the Passenger which typically drives pricing (e.g. ADT, CHD, etc).
     * 
     * @param PTC
     */
    public void setPTC(String PTC) {
        this.PTC = PTC;
    }
}
