
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * The OrderReshop transaction set passes new shopping requests to an airline to replace existing specified order or order items in an Order or for new shopping requests to add to an existing Order. Airline responds with product offers within the context of the existing Order.

 There is no change to the Order or Order Items, in response to a Reshop request - typically, the Reshop response will be followed by an OrderChangeRQ or OrderCancelRQ transaction, to commit the re-shop offer.

 In the response, the Airline can provide exact instructions as to what actions can finally be executed, as a solution to the initially requested action.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IATA_OrderReshopRQ">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:MessageDocType" name="MessageDoc" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:PartyType" name="Party" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:IATA_PayloadStandardAttributesType" name="PayloadAttributes" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:POS_Type" name="POS" minOccurs="0" maxOccurs="1"/>
 *       &lt;xs:element type="ns:RequestType" name="Request" minOccurs="1" maxOccurs="1"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class IATAOrderReshopRQ implements Serializable
{
    private MessageDocType messageDoc;
    private PartyType party;
    private IATAPayloadStandardAttributesType payloadAttributes;
    private POSType POS;
    private RequestType request;

    /** 
     * Get the 'MessageDoc' element value. Message document information.
     * 
     * @return value
     */
    public MessageDocType getMessageDoc() {
        return messageDoc;
    }

    /** 
     * Set the 'MessageDoc' element value. Message document information.
     * 
     * @param messageDoc
     */
    public void setMessageDoc(MessageDocType messageDoc) {
        this.messageDoc = messageDoc;
    }

    /** 
     * Get the 'Party' element value. NDC Message/ Transaction Party(s) information. Note that information about parties is intended for business use, it is not intended for transaction authentication and routing of the message.
     * 
     * @return value
     */
    public PartyType getParty() {
        return party;
    }

    /** 
     * Set the 'Party' element value. NDC Message/ Transaction Party(s) information. Note that information about parties is intended for business use, it is not intended for transaction authentication and routing of the message.
     * 
     * @param party
     */
    public void setParty(PartyType party) {
        this.party = party;
    }

    /** 
     * Get the 'PayloadAttributes' element value. IATA Standard Payload Attributes
     * 
     * @return value
     */
    public IATAPayloadStandardAttributesType getPayloadAttributes() {
        return payloadAttributes;
    }

    /** 
     * Set the 'PayloadAttributes' element value. IATA Standard Payload Attributes
     * 
     * @param payloadAttributes
     */
    public void setPayloadAttributes(
            IATAPayloadStandardAttributesType payloadAttributes) {
        this.payloadAttributes = payloadAttributes;
    }

    /** 
     * Get the 'POS' element value. Point of Sale information.
     * 
     * @return value
     */
    public POSType getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value. Point of Sale information.
     * 
     * @param POS
     */
    public void setPOS(POSType POS) {
        this.POS = POS;
    }

    /** 
     * Get the 'Request' element value. Reshop actions to enquire about desired changes for a given order. New OfferItems will be presented in subsequent response, which will incur reconstruction of new OrderItems post-OrderChangeRQ.
     * 
     * @return value
     */
    public RequestType getRequest() {
        return request;
    }

    /** 
     * Set the 'Request' element value. Reshop actions to enquire about desired changes for a given order. New OfferItems will be presented in subsequent response, which will incur reconstruction of new OrderItems post-OrderChangeRQ.
     * 
     * @param request
     */
    public void setRequest(RequestType request) {
        this.request = request;
    }
}
