
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * An account set up for a customer within a rewards program which holds funds on behalf of that customer.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LoyaltyProgramAccountType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AccountNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:LoyaltyProgramType" name="LoyaltyProgram" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SignInID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TierCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TierName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TierPriority" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LoyaltyProgramAccountType implements Serializable
{
    private String accountNumber;
    private LoyaltyProgramType loyaltyProgram;
    private String signInID;
    private String tierCode;
    private String tierName;
    private String tierPriority;

    /** 
     * Get the 'AccountNumber' element value. Loyalty Program account number. Example: ABC123456
     * 
     * @return value
     */
    public String getAccountNumber() {
        return accountNumber;
    }

    /** 
     * Set the 'AccountNumber' element value. Loyalty Program account number. Example: ABC123456
     * 
     * @param accountNumber
     */
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    /** 
     * Get the 'LoyaltyProgram' element value. A rewards program offered by a company to customers who frequently make purchases, which may give a customer advanced access to new products, special sales coupons or free merchandise.
     * 
     * @return value
     */
    public LoyaltyProgramType getLoyaltyProgram() {
        return loyaltyProgram;
    }

    /** 
     * Set the 'LoyaltyProgram' element value. A rewards program offered by a company to customers who frequently make purchases, which may give a customer advanced access to new products, special sales coupons or free merchandise.
     * 
     * @param loyaltyProgram
     */
    public void setLoyaltyProgram(LoyaltyProgramType loyaltyProgram) {
        this.loyaltyProgram = loyaltyProgram;
    }

    /** 
     * Get the 'SignInID' element value. Loyalty Program sign-in ID (or username).
     * 
     * @return value
     */
    public String getSignInID() {
        return signInID;
    }

    /** 
     * Set the 'SignInID' element value. Loyalty Program sign-in ID (or username).
     * 
     * @param signInID
     */
    public void setSignInID(String signInID) {
        this.signInID = signInID;
    }

    /** 
     * Get the 'TierCode' element value. Loyalty Program tier code.
     * 
     * @return value
     */
    public String getTierCode() {
        return tierCode;
    }

    /** 
     * Set the 'TierCode' element value. Loyalty Program tier code.
     * 
     * @param tierCode
     */
    public void setTierCode(String tierCode) {
        this.tierCode = tierCode;
    }

    /** 
     * Get the 'TierName' element value. Loyalty Program tier name.
     * 
     * @return value
     */
    public String getTierName() {
        return tierName;
    }

    /** 
     * Set the 'TierName' element value. Loyalty Program tier name.
     * 
     * @param tierName
     */
    public void setTierName(String tierName) {
        this.tierName = tierName;
    }

    /** 
     * Get the 'TierPriority' element value. Loyalty Program account priority within the tier (e.g. Platinum, executive, etc.)
     * 
     * @return value
     */
    public String getTierPriority() {
        return tierPriority;
    }

    /** 
     * Set the 'TierPriority' element value. Loyalty Program account priority within the tier (e.g. Platinum, executive, etc.)
     * 
     * @param tierPriority
     */
    public void setTierPriority(String tierPriority) {
        this.tierPriority = tierPriority;
    }
}
