
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * shows the current statuses of an Order Item
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderItemStatusCodeContentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="CANCELLED BY CUSTOMER"/>
 *     &lt;xs:enumeration value="ENTITLED"/>
 *     &lt;xs:enumeration value="NOT ENTITLED"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum OrderItemStatusCodeContentType implements Serializable {
    /** 
     * The Order Item reservation is cancelled by the Customer.
     */
    CANCELLEDBYCUSTOMER("CANCELLED BY CUSTOMER"), /** 
                                                   * Customer is entitled to receive the Order Item.
                                                   */
    ENTITLED("ENTITLED"), /** 
                           * Customer is not entitled to receive the Order Item until certain conditions are met.
                           */
    NOTENTITLED("NOT ENTITLED");
    private final String value;

    private OrderItemStatusCodeContentType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static OrderItemStatusCodeContentType convert(String value) {
        for (OrderItemStatusCodeContentType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
