
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CalendarDateCriteriaType" name="CalendarDateCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ConnectionPrefRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DestArrivalCriteriaType" name="DestArrivalCriteria" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:JourneyDurationCriteriaType" name="JourneyDurationCriteria" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OriginDepCriteriaType" name="OriginDepCriteria" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OriginDestID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CabinTypeType" name="PreferredCabinType" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OriginDestCriteriaType implements Serializable
{
    private CalendarDateCriteriaType calendarDateCriteria;
    private String connectionPrefRefID;
    private DestArrivalCriteriaType destArrivalCriteria;
    private JourneyDurationCriteriaType journeyDurationCriteria;
    private OriginDepCriteriaType originDepCriteria;
    private String originDestID;
    private List<CabinTypeType> preferredCabinTypeList = new ArrayList<CabinTypeType>();

    /** 
     * Get the 'CalendarDateCriteria' element value. Requests the airline to additionally include a preview of the Offer price for the same Shopping Criteria for the specified date range.
     * 
     * @return value
     */
    public CalendarDateCriteriaType getCalendarDateCriteria() {
        return calendarDateCriteria;
    }

    /** 
     * Set the 'CalendarDateCriteria' element value. Requests the airline to additionally include a preview of the Offer price for the same Shopping Criteria for the specified date range.
     * 
     * @param calendarDateCriteria
     */
    public void setCalendarDateCriteria(
            CalendarDateCriteriaType calendarDateCriteria) {
        this.calendarDateCriteria = calendarDateCriteria;
    }

    /** 
     * Get the 'ConnectionPrefRefID' element value. Reference to a transfer preference ID.
     * 
     * @return value
     */
    public String getConnectionPrefRefID() {
        return connectionPrefRefID;
    }

    /** 
     * Set the 'ConnectionPrefRefID' element value. Reference to a transfer preference ID.
     * 
     * @param connectionPrefRefID
     */
    public void setConnectionPrefRefID(String connectionPrefRefID) {
        this.connectionPrefRefID = connectionPrefRefID;
    }

    /** 
     * Get the 'DestArrivalCriteria' element value. A Customer's requested Destination arrival time and location.
     * 
     * @return value
     */
    public DestArrivalCriteriaType getDestArrivalCriteria() {
        return destArrivalCriteria;
    }

    /** 
     * Set the 'DestArrivalCriteria' element value. A Customer's requested Destination arrival time and location.
     * 
     * @param destArrivalCriteria
     */
    public void setDestArrivalCriteria(
            DestArrivalCriteriaType destArrivalCriteria) {
        this.destArrivalCriteria = destArrivalCriteria;
    }

    /** 
     * Get the 'JourneyDurationCriteria' element value. Total journey travel time preferences.  This includes the sum of all flight durations as well as connection times.
     * 
     * @return value
     */
    public JourneyDurationCriteriaType getJourneyDurationCriteria() {
        return journeyDurationCriteria;
    }

    /** 
     * Set the 'JourneyDurationCriteria' element value. Total journey travel time preferences.  This includes the sum of all flight durations as well as connection times.
     * 
     * @param journeyDurationCriteria
     */
    public void setJourneyDurationCriteria(
            JourneyDurationCriteriaType journeyDurationCriteria) {
        this.journeyDurationCriteria = journeyDurationCriteria;
    }

    /** 
     * Get the 'OriginDepCriteria' element value. A Customer's requested Origin departure time and location.
     * 
     * @return value
     */
    public OriginDepCriteriaType getOriginDepCriteria() {
        return originDepCriteria;
    }

    /** 
     * Set the 'OriginDepCriteria' element value. A Customer's requested Origin departure time and location.
     * 
     * @param originDepCriteria
     */
    public void setOriginDepCriteria(OriginDepCriteriaType originDepCriteria) {
        this.originDepCriteria = originDepCriteria;
    }

    /** 
     * Get the 'OriginDestID' element value. Uniquely identifies an Origin Destination within the context of one message.
     * 
     * @return value
     */
    public String getOriginDestID() {
        return originDestID;
    }

    /** 
     * Set the 'OriginDestID' element value. Uniquely identifies an Origin Destination within the context of one message.
     * 
     * @param originDestID
     */
    public void setOriginDestID(String originDestID) {
        this.originDestID = originDestID;
    }

    /** 
     * Get the list of 'PreferredCabinType' element items. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @return list
     */
    public List<CabinTypeType> getPreferredCabinTypeList() {
        return preferredCabinTypeList;
    }

    /** 
     * Set the list of 'PreferredCabinType' element items. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @param list
     */
    public void setPreferredCabinTypeList(List<CabinTypeType> list) {
        preferredCabinTypeList = list;
    }
}
