
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A collection of segments which satisfies transportation of a passenger for a given origin and destination.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaxJourneyType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Duration" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxJourneyID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaxSegmentType" name="PaxSegment" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaxJourneyType implements Serializable
{
    private String duration;
    private String paxJourneyID;
    private List<PaxSegmentType> paxSegmentList = new ArrayList<PaxSegmentType>();

    /** 
     * Get the 'Duration' element value. Total journey time including the combined air time and connection times.  In case of stopover, this may or may not include stopover durations.
     * 
     * @return value
     */
    public String getDuration() {
        return duration;
    }

    /** 
     * Set the 'Duration' element value. Total journey time including the combined air time and connection times.  In case of stopover, this may or may not include stopover durations.
     * 
     * @param duration
     */
    public void setDuration(String duration) {
        this.duration = duration;
    }

    /** 
     * Get the 'PaxJourneyID' element value. Uniquely identifies a Passenger Journey within the context of one message.
     * 
     * @return value
     */
    public String getPaxJourneyID() {
        return paxJourneyID;
    }

    /** 
     * Set the 'PaxJourneyID' element value. Uniquely identifies a Passenger Journey within the context of one message.
     * 
     * @param paxJourneyID
     */
    public void setPaxJourneyID(String paxJourneyID) {
        this.paxJourneyID = paxJourneyID;
    }

    /** 
     * Get the list of 'PaxSegment' element items. Transportation of a passenger on a Dated Operating Segment.
     * 
     * @return list
     */
    public List<PaxSegmentType> getPaxSegmentList() {
        return paxSegmentList;
    }

    /** 
     * Set the list of 'PaxSegment' element items. Transportation of a passenger on a Dated Operating Segment.
     * 
     * @param list
     */
    public void setPaxSegmentList(List<PaxSegmentType> list) {
        paxSegmentList = list;
    }
}
