
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to fulfillment.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaxType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:MeasureType" name="AgeMeasure" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="Birthdate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CitizenshipCountryCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ContactInfoType" name="ContactInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:FOID_Type" name="FOID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:IdentityDocType" name="IdentityDoc" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:IndividualType" name="Individual" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:LangUsageType" name="LangUsage" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:LoyaltyProgramAccountType" name="LoyaltyProgramAccount" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PaxID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="ProfileConsentInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ProfileID_Text" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PTC" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:RedressCaseType" name="RedressCase" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:RemarkType" name="Remark" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="ResidenceCountryCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaxType implements Serializable
{
    private MeasureType ageMeasure;
    private Date birthdate;
    private String citizenshipCountryCode;
    private List<ContactInfoType> contactInfoList = new ArrayList<ContactInfoType>();
    private FOIDType FOID;
    private List<IdentityDocType> identityDocList = new ArrayList<IdentityDocType>();
    private IndividualType individual;
    private List<LangUsageType> langUsageList = new ArrayList<LangUsageType>();
    private List<LoyaltyProgramAccountType> loyaltyProgramAccountList = new ArrayList<LoyaltyProgramAccountType>();
    private String paxID;
    private String paxRefID;
    private Boolean profileConsentInd;
    private String profileIDText;
    private String PTC;
    private List<RedressCaseType> redressCaseList = new ArrayList<RedressCaseType>();
    private List<RemarkType> remarkList = new ArrayList<RemarkType>();
    private String residenceCountryCode;

    /** 
     * Get the 'AgeMeasure' element value. The Age of the Passenger.  To be used in NDC Anonymous Shopping requests or when the birthdate (in Individual) is not known.
     * 
     * @return value
     */
    public MeasureType getAgeMeasure() {
        return ageMeasure;
    }

    /** 
     * Set the 'AgeMeasure' element value. The Age of the Passenger.  To be used in NDC Anonymous Shopping requests or when the birthdate (in Individual) is not known.
     * 
     * @param ageMeasure
     */
    public void setAgeMeasure(MeasureType ageMeasure) {
        this.ageMeasure = ageMeasure;
    }

    /** 
     * Get the 'Birthdate' element value. The Date of Birth of the Passenger.  Intended to be used in NDC Anonymous Shopping requests. Example: 2017-01-13
     * 
     * @return value
     */
    public Date getBirthdate() {
        return birthdate;
    }

    /** 
     * Set the 'Birthdate' element value. The Date of Birth of the Passenger.  Intended to be used in NDC Anonymous Shopping requests. Example: 2017-01-13
     * 
     * @param birthdate
     */
    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    /** 
     * Get the 'CitizenshipCountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @return value
     */
    public String getCitizenshipCountryCode() {
        return citizenshipCountryCode;
    }

    /** 
     * Set the 'CitizenshipCountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @param citizenshipCountryCode
     */
    public void setCitizenshipCountryCode(String citizenshipCountryCode) {
        this.citizenshipCountryCode = citizenshipCountryCode;
    }

    /** 
     * Get the list of 'ContactInfo' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * 
     * @return list
     */
    public List<ContactInfoType> getContactInfoList() {
        return contactInfoList;
    }

    /** 
     * Set the list of 'ContactInfo' element items. The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
     * 
     * @param list
     */
    public void setContactInfoList(List<ContactInfoType> list) {
        contactInfoList = list;
    }

    /** 
     * Get the 'FOID' element value. Form of identification.  Typically used to identify that the passenger is who he says he is.  This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).
     * 
     * @return value
     */
    public FOIDType getFOID() {
        return FOID;
    }

    /** 
     * Set the 'FOID' element value. Form of identification.  Typically used to identify that the passenger is who he says he is.  This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).
     * 
     * @param FOID
     */
    public void setFOID(FOIDType FOID) {
        this.FOID = FOID;
    }

    /** 
     * Get the list of 'IdentityDoc' element items. Any document which may be used to identify a person or verify aspects of a person's personal identity. If issued in a small, standard credit card size form, it is usually called an identity card. Some countries issue formal identity documents, while others may require identity verification using informal documents. When the identity document incorporates a person's photograph, it may be called photo ID.  In the absence of a formal identity document, a driver's license may be accepted in many countries for identity verification. Most countries accept passports as a form of identification.
     * 
     * @return list
     */
    public List<IdentityDocType> getIdentityDocList() {
        return identityDocList;
    }

    /** 
     * Set the list of 'IdentityDoc' element items. Any document which may be used to identify a person or verify aspects of a person's personal identity. If issued in a small, standard credit card size form, it is usually called an identity card. Some countries issue formal identity documents, while others may require identity verification using informal documents. When the identity document incorporates a person's photograph, it may be called photo ID.  In the absence of a formal identity document, a driver's license may be accepted in many countries for identity verification. Most countries accept passports as a form of identification.
     * 
     * @param list
     */
    public void setIdentityDocList(List<IdentityDocType> list) {
        identityDocList = list;
    }

    /** 
     * Get the 'Individual' element value. A single human being as distinct from a group, class, or family.
     * 
     * @return value
     */
    public IndividualType getIndividual() {
        return individual;
    }

    /** 
     * Set the 'Individual' element value. A single human being as distinct from a group, class, or family.
     * 
     * @param individual
     */
    public void setIndividual(IndividualType individual) {
        this.individual = individual;
    }

    /** 
     * Get the list of 'LangUsage' element items. Language Code representation.
     * 
     * @return list
     */
    public List<LangUsageType> getLangUsageList() {
        return langUsageList;
    }

    /** 
     * Set the list of 'LangUsage' element items. Language Code representation.
     * 
     * @param list
     */
    public void setLangUsageList(List<LangUsageType> list) {
        langUsageList = list;
    }

    /** 
     * Get the list of 'LoyaltyProgramAccount' element items. An account set up for a customer within a rewards program which holds funds on behalf of that customer.
     * 
     * @return list
     */
    public List<LoyaltyProgramAccountType> getLoyaltyProgramAccountList() {
        return loyaltyProgramAccountList;
    }

    /** 
     * Set the list of 'LoyaltyProgramAccount' element items. An account set up for a customer within a rewards program which holds funds on behalf of that customer.
     * 
     * @param list
     */
    public void setLoyaltyProgramAccountList(
            List<LoyaltyProgramAccountType> list) {
        loyaltyProgramAccountList = list;
    }

    /** 
     * Get the 'PaxID' element value. Uniquely identifies a Passenger within the context of one message.
     * 
     * @return value
     */
    public String getPaxID() {
        return paxID;
    }

    /** 
     * Set the 'PaxID' element value. Uniquely identifies a Passenger within the context of one message.
     * 
     * @param paxID
     */
    public void setPaxID(String paxID) {
        this.paxID = paxID;
    }

    /** 
     * Get the 'PaxRefID' element value. Reference to a Passenger ID within this message, associating an infant on lap to this adult Passenger.
     * 
     * @return value
     */
    public String getPaxRefID() {
        return paxRefID;
    }

    /** 
     * Set the 'PaxRefID' element value. Reference to a Passenger ID within this message, associating an infant on lap to this adult Passenger.
     * 
     * @param paxRefID
     */
    public void setPaxRefID(String paxRefID) {
        this.paxRefID = paxRefID;
    }

    /** 
     * Get the 'ProfileConsentInd' element value. When TRUE, passenger authorizes the airline to share his/her profile information or send promotional emails.
     * 
     * @return value
     */
    public Boolean getProfileConsentInd() {
        return profileConsentInd;
    }

    /** 
     * Set the 'ProfileConsentInd' element value. When TRUE, passenger authorizes the airline to share his/her profile information or send promotional emails.
     * 
     * @param profileConsentInd
     */
    public void setProfileConsentInd(Boolean profileConsentInd) {
        this.profileConsentInd = profileConsentInd;
    }

    /** 
     * Get the 'ProfileID_Text' element value. Passenger Profile ID
     * 
     * @return value
     */
    public String getProfileIDText() {
        return profileIDText;
    }

    /** 
     * Set the 'ProfileID_Text' element value. Passenger Profile ID
     * 
     * @param profileIDText
     */
    public void setProfileIDText(String profileIDText) {
        this.profileIDText = profileIDText;
    }

    /** 
     * Get the 'PTC' element value. Type code applying to the Passenger which typically drives pricing (e.g. ADT, CHD, etc).
     * 
     * @return value
     */
    public String getPTC() {
        return PTC;
    }

    /** 
     * Set the 'PTC' element value. Type code applying to the Passenger which typically drives pricing (e.g. ADT, CHD, etc).
     * 
     * @param PTC
     */
    public void setPTC(String PTC) {
        this.PTC = PTC;
    }

    /** 
     * Get the list of 'RedressCase' element items. A personâ€™s case of being registered with a countryâ€™s redress program, which can eliminate watch list misidentification and assist in identity verification.
     * 
     * @return list
     */
    public List<RedressCaseType> getRedressCaseList() {
        return redressCaseList;
    }

    /** 
     * Set the list of 'RedressCase' element items. A personâ€™s case of being registered with a countryâ€™s redress program, which can eliminate watch list misidentification and assist in identity verification.
     * 
     * @param list
     */
    public void setRedressCaseList(List<RedressCaseType> list) {
        redressCaseList = list;
    }

    /** 
     * Get the list of 'Remark' element items. Additional, supplementary information about the document or service.
     * 
     * @return list
     */
    public List<RemarkType> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items. Additional, supplementary information about the document or service.
     * 
     * @param list
     */
    public void setRemarkList(List<RemarkType> list) {
        remarkList = list;
    }

    /** 
     * Get the 'ResidenceCountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @return value
     */
    public String getResidenceCountryCode() {
        return residenceCountryCode;
    }

    /** 
     * Set the 'ResidenceCountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @param residenceCountryCode
     */
    public void setResidenceCountryCode(String residenceCountryCode) {
        this.residenceCountryCode = residenceCountryCode;
    }
}
