
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Filtering criteria based on discount programs.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ProgramCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CompanyIndexText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="MemberStatusText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PrePaidCertificateType" name="PrePaidCertificate" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ProgamContractType" name="ProgamContract" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ProgramAccountType" name="ProgramAccount" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ProgramOwnerType" name="ProgramOwner" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TypeCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ProgramCriteriaType implements Serializable
{
    private String companyIndexText;
    private String memberStatusText;
    private String name;
    private List<PrePaidCertificateType> prePaidCertificateList = new ArrayList<PrePaidCertificateType>();
    private ProgamContractType progamContract;
    private List<ProgramAccountType> programAccountList = new ArrayList<ProgramAccountType>();
    private ProgramOwnerType programOwner;
    private String typeCode;

    /** 
     * Get the 'CompanyIndexText' element value. Company profile index associated with this special fare. Example: COM1234
     * 
     * @return value
     */
    public String getCompanyIndexText() {
        return companyIndexText;
    }

    /** 
     * Set the 'CompanyIndexText' element value. Company profile index associated with this special fare. Example: COM1234
     * 
     * @param companyIndexText
     */
    public void setCompanyIndexText(String companyIndexText) {
        this.companyIndexText = companyIndexText;
    }

    /** 
     * Get the 'MemberStatusText' element value. Member or participant status within the program (e.g. VP, Director, Exec).
     * 
     * @return value
     */
    public String getMemberStatusText() {
        return memberStatusText;
    }

    /** 
     * Set the 'MemberStatusText' element value. Member or participant status within the program (e.g. VP, Director, Exec).
     * 
     * @param memberStatusText
     */
    public void setMemberStatusText(String memberStatusText) {
        this.memberStatusText = memberStatusText;
    }

    /** 
     * Get the 'Name' element value. The name of the program.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. The name of the program.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the list of 'PrePaidCertificate' element items.
     * 
     * @return list
     */
    public List<PrePaidCertificateType> getPrePaidCertificateList() {
        return prePaidCertificateList;
    }

    /** 
     * Set the list of 'PrePaidCertificate' element items.
     * 
     * @param list
     */
    public void setPrePaidCertificateList(List<PrePaidCertificateType> list) {
        prePaidCertificateList = list;
    }

    /** 
     * Get the 'ProgamContract' element value. a written or spoken agreement, especially one concerning employment, sales, or tenancy, that is intended to be enforceable by law
     * 
     * @return value
     */
    public ProgamContractType getProgamContract() {
        return progamContract;
    }

    /** 
     * Set the 'ProgamContract' element value. a written or spoken agreement, especially one concerning employment, sales, or tenancy, that is intended to be enforceable by law
     * 
     * @param progamContract
     */
    public void setProgamContract(ProgamContractType progamContract) {
        this.progamContract = progamContract;
    }

    /** 
     * Get the list of 'ProgramAccount' element items.
     * 
     * @return list
     */
    public List<ProgramAccountType> getProgramAccountList() {
        return programAccountList;
    }

    /** 
     * Set the list of 'ProgramAccount' element items.
     * 
     * @param list
     */
    public void setProgramAccountList(List<ProgramAccountType> list) {
        programAccountList = list;
    }

    /** 
     * Get the 'ProgramOwner' element value. Program Owner information.
     * 
     * @return value
     */
    public ProgramOwnerType getProgramOwner() {
        return programOwner;
    }

    /** 
     * Set the 'ProgramOwner' element value. Program Owner information.
     * 
     * @param programOwner
     */
    public void setProgramOwner(ProgramOwnerType programOwner) {
        this.programOwner = programOwner;
    }

    /** 
     * Get the 'TypeCode' element value. Program type code (e.g. Discount Program, Incentive Program, Pre-paid Program).
     * 
     * @return value
     */
    public String getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' element value. Program type code (e.g. Discount Program, Incentive Program, Pre-paid Program).
     * 
     * @param typeCode
     */
    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }
}
