
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * A personâ€™s case of being registered with a countryâ€™s redress program, which can eliminate watch list misidentification and assist in identity verification.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RedressCaseType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ProgramName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RedressCaseID" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RedressCaseType implements Serializable
{
    private String programName;
    private String redressCaseID;

    /** 
     * Get the 'ProgramName' element value. The name of the redress program (e.g. Secure Flight Program).
     * 
     * @return value
     */
    public String getProgramName() {
        return programName;
    }

    /** 
     * Set the 'ProgramName' element value. The name of the redress program (e.g. Secure Flight Program).
     * 
     * @param programName
     */
    public void setProgramName(String programName) {
        this.programName = programName;
    }

    /** 
     * Get the 'RedressCaseID' element value. A unique government-issued identifier assigned to a redress case.
     * 
     * @return value
     */
    public String getRedressCaseID() {
        return redressCaseID;
    }

    /** 
     * Set the 'RedressCaseID' element value. A unique government-issued identifier assigned to a redress case.
     * 
     * @param redressCaseID
     */
    public void setRedressCaseID(String redressCaseID) {
        this.redressCaseID = redressCaseID;
    }
}
