
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Function used to reshop items within an Order (e.g. adding ancillaries, canceling Order Items, or replacing Order Items.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReshopOrderType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:ServiceOrderType" name="ServiceOrder" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:UpdatePaxNameType" name="UpdatePaxName" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReshopOrderType implements Serializable
{
    private int choiceSelect = -1;
    private static final int SERVICE_ORDER_CHOICE = 0;
    private static final int UPDATE_PAX_NAME_CHOICE = 1;
    private ServiceOrderType serviceOrder;
    private UpdatePaxNameType updatePaxName;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if ServiceOrder is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifServiceOrder() {
        return choiceSelect == SERVICE_ORDER_CHOICE;
    }

    /** 
     * Get the 'ServiceOrder' element value. Functions to allow a Seller to request additions, replacement or deletions of OrderItems in this specific Order.
     * 
     * @return value
     */
    public ServiceOrderType getServiceOrder() {
        return serviceOrder;
    }

    /** 
     * Set the 'ServiceOrder' element value. Functions to allow a Seller to request additions, replacement or deletions of OrderItems in this specific Order.
     * 
     * @param serviceOrder
     */
    public void setServiceOrder(ServiceOrderType serviceOrder) {
        setChoiceSelect(SERVICE_ORDER_CHOICE);
        this.serviceOrder = serviceOrder;
    }

    /** 
     * Check if UpdatePaxName is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifUpdatePaxName() {
        return choiceSelect == UPDATE_PAX_NAME_CHOICE;
    }

    /** 
     * Get the 'UpdatePaxName' element value. Request to Airline whether any fees will apply to a proposed correction to a Passenger's name details.
     * 
     * @return value
     */
    public UpdatePaxNameType getUpdatePaxName() {
        return updatePaxName;
    }

    /** 
     * Set the 'UpdatePaxName' element value. Request to Airline whether any fees will apply to a proposed correction to a Passenger's name details.
     * 
     * @param updatePaxName
     */
    public void setUpdatePaxName(UpdatePaxNameType updatePaxName) {
        setChoiceSelect(UPDATE_PAX_NAME_CHOICE);
        this.updatePaxName = updatePaxName;
    }
}
