
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information related to how shopping results should be returned in the response.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResponseParametersType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BDC_Type" name="BDC" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CurParameterType" name="CurParameter" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:boolean" name="InventoryGuaranteeInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:LangUsageType" name="LangUsage" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:MeasurementSystemCodeContentType" name="MeasurementSystemCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaxGroupType" name="PaxGroup" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PricingParameterType" name="PricingParameter" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ResponseParametersType implements Serializable
{
    private BDCType BDC;
    private List<CurParameterType> curParameterList = new ArrayList<CurParameterType>();
    private Boolean inventoryGuaranteeInd;
    private List<LangUsageType> langUsageList = new ArrayList<LangUsageType>();
    private MeasurementSystemCodeContentType measurementSystemCode;
    private PaxGroupType paxGroup;
    private PricingParameterType pricingParameter;

    /** 
     * Get the 'BDC' element value. The carrier whose baggage allowances and charges apply.
     * 
     * @return value
     */
    public BDCType getBDC() {
        return BDC;
    }

    /** 
     * Set the 'BDC' element value. The carrier whose baggage allowances and charges apply.
     * 
     * @param BDC
     */
    public void setBDC(BDCType BDC) {
        this.BDC = BDC;
    }

    /** 
     * Get the list of 'CurParameter' element items. Requested search processing and results currency information.
     * 
     * @return list
     */
    public List<CurParameterType> getCurParameterList() {
        return curParameterList;
    }

    /** 
     * Set the list of 'CurParameter' element items. Requested search processing and results currency information.
     * 
     * @param list
     */
    public void setCurParameterList(List<CurParameterType> list) {
        curParameterList = list;
    }

    /** 
     * Get the 'InventoryGuaranteeInd' element value. When TRUE, inventory guarantee is requested for applicable optional services.
     * 
     * @return value
     */
    public Boolean getInventoryGuaranteeInd() {
        return inventoryGuaranteeInd;
    }

    /** 
     * Set the 'InventoryGuaranteeInd' element value. When TRUE, inventory guarantee is requested for applicable optional services.
     * 
     * @param inventoryGuaranteeInd
     */
    public void setInventoryGuaranteeInd(Boolean inventoryGuaranteeInd) {
        this.inventoryGuaranteeInd = inventoryGuaranteeInd;
    }

    /** 
     * Get the list of 'LangUsage' element items. Language Code representation.
     * 
     * @return list
     */
    public List<LangUsageType> getLangUsageList() {
        return langUsageList;
    }

    /** 
     * Set the list of 'LangUsage' element items. Language Code representation.
     * 
     * @param list
     */
    public void setLangUsageList(List<LangUsageType> list) {
        langUsageList = list;
    }

    /** 
     * Get the 'MeasurementSystemCode' element value. Measurement system code.  Examples: Imperial, Metric
     * 
     * @return value
     */
    public MeasurementSystemCodeContentType getMeasurementSystemCode() {
        return measurementSystemCode;
    }

    /** 
     * Set the 'MeasurementSystemCode' element value. Measurement system code.  Examples: Imperial, Metric
     * 
     * @param measurementSystemCode
     */
    public void setMeasurementSystemCode(
            MeasurementSystemCodeContentType measurementSystemCode) {
        this.measurementSystemCode = measurementSystemCode;
    }

    /** 
     * Get the 'PaxGroup' element value. A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency.
     * 
     * @return value
     */
    public PaxGroupType getPaxGroup() {
        return paxGroup;
    }

    /** 
     * Set the 'PaxGroup' element value. A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency.
     * 
     * @param paxGroup
     */
    public void setPaxGroup(PaxGroupType paxGroup) {
        this.paxGroup = paxGroup;
    }

    /** 
     * Get the 'PricingParameter' element value. Pricing Parameters, including Simple Pricing, Award Travel, Auto Exchange, Override Currency and Tax Exemption.
     * 
     * @return value
     */
    public PricingParameterType getPricingParameter() {
        return pricingParameter;
    }

    /** 
     * Set the 'PricingParameter' element value. Pricing Parameters, including Simple Pricing, Award Travel, Auto Exchange, Override Currency and Tax Exemption.
     * 
     * @param pricingParameter
     */
    public void setPricingParameter(PricingParameterType pricingParameter) {
        this.pricingParameter = pricingParameter;
    }
}
