
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Airline defined group of seats sharing common characteristics.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CharacteristicCode" minOccurs="0" maxOccurs="99"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatProfileType implements Serializable
{
    private List<String> characteristicCodeList = new ArrayList<String>();

    /** 
     * Get the list of 'CharacteristicCode' element items. Seat characteristic/property code (e.g. A - Aisle Seat, W - Window Seat, etc.).
     * 
     * @return list
     */
    public List<String> getCharacteristicCodeList() {
        return characteristicCodeList;
    }

    /** 
     * Set the list of 'CharacteristicCode' element items. Seat characteristic/property code (e.g. A - Aisle Seat, W - Window Seat, etc.).
     * 
     * @param list
     */
    public void setCharacteristicCodeList(List<String> list) {
        characteristicCodeList = list;
    }
}
