
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Group and subgroup code(s) that specify the requested categories of Optional Services to be returned in the results.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:boolean" name="IncludeInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PrefLevelType" name="PrefLevel" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RFIC" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RFISC" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="xs:boolean" name="ServicePricingOnlyInd" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceCriteriaType implements Serializable
{
    private Boolean includeInd;
    private PrefLevelType prefLevel;
    private String RFIC;
    private List<String> RFISCList = new ArrayList<String>();
    private Boolean servicePricingOnlyInd;

    /** 
     * Get the 'IncludeInd' element value. When TRUE, specified service should be included in search results.  When FALSE, exclude shopping results including the specified service.
     * 
     * @return value
     */
    public Boolean getIncludeInd() {
        return includeInd;
    }

    /** 
     * Set the 'IncludeInd' element value. When TRUE, specified service should be included in search results.  When FALSE, exclude shopping results including the specified service.
     * 
     * @param includeInd
     */
    public void setIncludeInd(Boolean includeInd) {
        this.includeInd = includeInd;
    }

    /** 
     * Get the 'PrefLevel' element value. Information supporting a preference including preference level code (e.g. Preferred, Exclude, etc.).
     * 
     * @return value
     */
    public PrefLevelType getPrefLevel() {
        return prefLevel;
    }

    /** 
     * Set the 'PrefLevel' element value. Information supporting a preference including preference level code (e.g. Preferred, Exclude, etc.).
     * 
     * @param prefLevel
     */
    public void setPrefLevel(PrefLevelType prefLevel) {
        this.prefLevel = prefLevel;
    }

    /** 
     * Get the 'RFIC' element value. Reason For Issuance Code  Examples: A (Air Transportation) C (Baggage) E (Airport Services) F (Merchandise) G (In-flight Services) Refer to PADIS Codeset for data element 4183 - Special Condition.
     * 
     * @return value
     */
    public String getRFIC() {
        return RFIC;
    }

    /** 
     * Set the 'RFIC' element value. Reason For Issuance Code  Examples: A (Air Transportation) C (Baggage) E (Airport Services) F (Merchandise) G (In-flight Services) Refer to PADIS Codeset for data element 4183 - Special Condition.
     * 
     * @param RFIC
     */
    public void setRFIC(String RFIC) {
        this.RFIC = RFIC;
    }

    /** 
     * Get the list of 'RFISC' element items. Reason For Issuance Sub Code. Examples: 0CC (First Checked Bag) 0B1 (In-flight Entertainment) 0BX (Lounge)
     * 
     * @return list
     */
    public List<String> getRFISCList() {
        return RFISCList;
    }

    /** 
     * Set the list of 'RFISC' element items. Reason For Issuance Sub Code. Examples: 0CC (First Checked Bag) 0B1 (In-flight Entertainment) 0BX (Lounge)
     * 
     * @param list
     */
    public void setRFISCList(List<String> list) {
        RFISCList = list;
    }

    /** 
     * Get the 'ServicePricingOnlyInd' element value. When TRUE, service pricing only is requested.
     * 
     * @return value
     */
    public Boolean getServicePricingOnlyInd() {
        return servicePricingOnlyInd;
    }

    /** 
     * Set the 'ServicePricingOnlyInd' element value. When TRUE, service pricing only is requested.
     * 
     * @param servicePricingOnlyInd
     */
    public void setServicePricingOnlyInd(Boolean servicePricingOnlyInd) {
        this.servicePricingOnlyInd = servicePricingOnlyInd;
    }
}
