
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Functions to allow a Seller to request additions, replacement or deletions of OrderItems in this specific Order.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceOrderType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AddOfferItemsType" name="AddOfferItems" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DeleteOrderItemType" name="DeleteOrderItem" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceOrderType implements Serializable
{
    private AddOfferItemsType addOfferItems;
    private List<DeleteOrderItemType> deleteOrderItemList = new ArrayList<DeleteOrderItemType>();

    /** 
     * Get the 'AddOfferItems' element value. Action to request new Offer Items for the specified Order.  If used in conjunction with a â€œDeleteâ€&#157; function, the intention is to replace the deleted item with whatever has been requested in this Add functionâ€™s shopping query.
     * 
     * @return value
     */
    public AddOfferItemsType getAddOfferItems() {
        return addOfferItems;
    }

    /** 
     * Set the 'AddOfferItems' element value. Action to request new Offer Items for the specified Order.  If used in conjunction with a â€œDeleteâ€&#157; function, the intention is to replace the deleted item with whatever has been requested in this Add functionâ€™s shopping query.
     * 
     * @param addOfferItems
     */
    public void setAddOfferItems(AddOfferItemsType addOfferItems) {
        this.addOfferItems = addOfferItems;
    }

    /** 
     * Get the list of 'DeleteOrderItem' element items. Function to request the removal of Order Items from this specific Order.  If used alone (without a shopping query from the â€œAddâ€&#157; function), the RS will assume a cancellation is desired for the Order Items specified and will return incurred fees/refund
     * 
     * @return list
     */
    public List<DeleteOrderItemType> getDeleteOrderItemList() {
        return deleteOrderItemList;
    }

    /** 
     * Set the list of 'DeleteOrderItem' element items. Function to request the removal of Order Items from this specific Order.  If used alone (without a shopping query from the â€œAddâ€&#157; function), the RS will assume a cancellation is desired for the Order Items specified and will return incurred fees/refund
     * 
     * @param list
     */
    public void setDeleteOrderItemList(List<DeleteOrderItemType> list) {
        deleteOrderItemList = list;
    }
}
