
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Shopping session (message response) ID.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ShoppingResponseType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OfferRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ShoppingResponseRefID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ShoppingResponseType implements Serializable
{
    private String offerRefID;
    private String ownerCode;
    private String shoppingResponseRefID;

    /** 
     * Get the 'OfferRefID' element value. Reference to an Offer ID for which this Payment applies.
     * 
     * @return value
     */
    public String getOfferRefID() {
        return offerRefID;
    }

    /** 
     * Set the 'OfferRefID' element value. Reference to an Offer ID for which this Payment applies.
     * 
     * @param offerRefID
     */
    public void setOfferRefID(String offerRefID) {
        this.offerRefID = offerRefID;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'ShoppingResponseRefID' element value. Reference to unique shopping session response ID, as provided in the airline's previous shopping response.
     * 
     * @return value
     */
    public String getShoppingResponseRefID() {
        return shoppingResponseRefID;
    }

    /** 
     * Set the 'ShoppingResponseRefID' element value. Reference to unique shopping session response ID, as provided in the airline's previous shopping response.
     * 
     * @param shoppingResponseRefID
     */
    public void setShoppingResponseRefID(String shoppingResponseRefID) {
        this.shoppingResponseRefID = shoppingResponseRefID;
    }
}
