
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Time constraints for an Affinity Shopping request including specific Dates, Seasons, Months, or Durations.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StayPeriodType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:date" name="EndDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="MaximumStayNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="MinimumStayNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="StartDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="StayMonthName" minOccurs="0" maxOccurs="12"/>
 *     &lt;xs:element type="xs:string" name="StayQuarterText" minOccurs="0" maxOccurs="4"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StayPeriodType implements Serializable
{
    private Date endDate;
    private BigDecimal maximumStayNumber;
    private BigDecimal minimumStayNumber;
    private Date startDate;
    private List<String> stayMonthNameList = new ArrayList<String>();
    private List<String> stayQuarterTextList = new ArrayList<String>();

    /** 
     * Get the 'EndDate' element value. Ending date of the stay period.
     * 
     * @return value
     */
    public Date getEndDate() {
        return endDate;
    }

    /** 
     * Set the 'EndDate' element value. Ending date of the stay period.
     * 
     * @param endDate
     */
    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    /** 
     * Get the 'MaximumStayNumber' element value. Maximum stay period within the specified date or calendar range.
     * 
     * @return value
     */
    public BigDecimal getMaximumStayNumber() {
        return maximumStayNumber;
    }

    /** 
     * Set the 'MaximumStayNumber' element value. Maximum stay period within the specified date or calendar range.
     * 
     * @param maximumStayNumber
     */
    public void setMaximumStayNumber(BigDecimal maximumStayNumber) {
        this.maximumStayNumber = maximumStayNumber;
    }

    /** 
     * Get the 'MinimumStayNumber' element value. Minimum stay period within the specified date or calendar range.
     * 
     * @return value
     */
    public BigDecimal getMinimumStayNumber() {
        return minimumStayNumber;
    }

    /** 
     * Set the 'MinimumStayNumber' element value. Minimum stay period within the specified date or calendar range.
     * 
     * @param minimumStayNumber
     */
    public void setMinimumStayNumber(BigDecimal minimumStayNumber) {
        this.minimumStayNumber = minimumStayNumber;
    }

    /** 
     * Get the 'StartDate' element value. Starting Date of the stay period.
     * 
     * @return value
     */
    public Date getStartDate() {
        return startDate;
    }

    /** 
     * Set the 'StartDate' element value. Starting Date of the stay period.
     * 
     * @param startDate
     */
    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    /** 
     * Get the list of 'StayMonthName' element items. Name of the Month for which the stay is requested.
     * 
     * @return list
     */
    public List<String> getStayMonthNameList() {
        return stayMonthNameList;
    }

    /** 
     * Set the list of 'StayMonthName' element items. Name of the Month for which the stay is requested.
     * 
     * @param list
     */
    public void setStayMonthNameList(List<String> list) {
        stayMonthNameList = list;
    }

    /** 
     * Get the list of 'StayQuarterText' element items. Calendar (yearly) quarter which corresponds to the stay period.
     * 
     * @return list
     */
    public List<String> getStayQuarterTextList() {
        return stayQuarterTextList;
    }

    /** 
     * Set the list of 'StayQuarterText' element items. Calendar (yearly) quarter which corresponds to the stay period.
     * 
     * @param list
     */
    public void setStayQuarterTextList(List<String> list) {
        stayQuarterTextList = list;
    }
}
