
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Individual agent who solicits and procures business from potential customers on behalf of one or more principals, usually against payment of a percentage of the realized sales revenue as commission.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelAgentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="TravelAgentID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TravelAgencyTypeCodeContentType" name="TypeCode" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelAgentType implements Serializable
{
    private String travelAgentID;
    private TravelAgencyTypeCodeContentType typeCode;

    /** 
     * Get the 'TravelAgentID' element value. Booking and Servicing Agent information. ID. Example: 98417900 Note: The ID correlates to the specified ID Type.
     * 
     * @return value
     */
    public String getTravelAgentID() {
        return travelAgentID;
    }

    /** 
     * Set the 'TravelAgentID' element value. Booking and Servicing Agent information. ID. Example: 98417900 Note: The ID correlates to the specified ID Type.
     * 
     * @param travelAgentID
     */
    public void setTravelAgentID(String travelAgentID) {
        this.travelAgentID = travelAgentID;
    }

    /** 
     * Get the 'TypeCode' element value. Agency/ Agent Identification Type. Example: B - Booking Agent
     * 
     * @return value
     */
    public TravelAgencyTypeCodeContentType getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' element value. Agency/ Agent Identification Type. Example: B - Booking Agent
     * 
     * @param typeCode
     */
    public void setTypeCode(TravelAgencyTypeCodeContentType typeCode) {
        this.typeCode = typeCode;
    }
}
