
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;

/** 
 * Enumeration set for the trip purpose code Type BDT.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TripPurposeCodeContentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Business"/>
 *     &lt;xs:enumeration value="BusinessAndLeisure"/>
 *     &lt;xs:enumeration value="Leisure"/>
 *     &lt;xs:enumeration value="Other"/>
 *     &lt;xs:enumeration value="Unknown"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum TripPurposeCodeContentType implements Serializable {
    BUSINESS("Business"), BUSINESS_AND_LEISURE("BusinessAndLeisure"), LEISURE(
            "Leisure"), OTHER("Other"), UNKNOWN("Unknown");
    private final String value;

    private TripPurposeCodeContentType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static TripPurposeCodeContentType convert(String value) {
        for (TripPurposeCodeContentType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
