
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Request to Airline whether any fees will apply to a proposed correction to a Passenger's name details.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UpdatePaxNameType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="GivenName" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0" maxOccurs="3"/>
 *     &lt;xs:element type="xs:string" name="PaxRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SuffixName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Surname" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TitleName" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class UpdatePaxNameType implements Serializable
{
    private List<String> givenNameList = new ArrayList<String>();
    private List<String> middleNameList = new ArrayList<String>();
    private String paxRefID;
    private String suffixName;
    private String surname;
    private String titleName;

    /** 
     * Get the list of 'GivenName' element items. A personal name given to the individual at birthÂ and used before aÂ family name. Also called first name. E.g. JOHN.
     * 
     * @return list
     */
    public List<String> getGivenNameList() {
        return givenNameList;
    }

    /** 
     * Set the list of 'GivenName' element items. A personal name given to the individual at birthÂ and used before aÂ family name. Also called first name. E.g. JOHN.
     * 
     * @param list
     */
    public void setGivenNameList(List<String> list) {
        givenNameList = list;
    }

    /** 
     * Get the list of 'MiddleName' element items. Individual's middle name or initial.  E.g. G, GEORGE.
     * 
     * @return list
     */
    public List<String> getMiddleNameList() {
        return middleNameList;
    }

    /** 
     * Set the list of 'MiddleName' element items. Individual's middle name or initial.  E.g. G, GEORGE.
     * 
     * @param list
     */
    public void setMiddleNameList(List<String> list) {
        middleNameList = list;
    }

    /** 
     * Get the 'PaxRefID' element value. Reference to the Passenger ID for whom the name change is requested.
     * 
     * @return value
     */
    public String getPaxRefID() {
        return paxRefID;
    }

    /** 
     * Set the 'PaxRefID' element value. Reference to the Passenger ID for whom the name change is requested.
     * 
     * @param paxRefID
     */
    public void setPaxRefID(String paxRefID) {
        this.paxRefID = paxRefID;
    }

    /** 
     * Get the 'SuffixName' element value. Individual's name suffixes and letters. Examples: Jr., Sr., III, Ret., Esq.
     * 
     * @return value
     */
    public String getSuffixName() {
        return suffixName;
    }

    /** 
     * Set the 'SuffixName' element value. Individual's name suffixes and letters. Examples: Jr., Sr., III, Ret., Esq.
     * 
     * @param suffixName
     */
    public void setSuffixName(String suffixName) {
        this.suffixName = suffixName;
    }

    /** 
     * Get the 'Surname' element value. Individual's hereditaryÂ name(s) common to all members of a family. Also known as family name or last name. E.g. SMITH. Excludes any potential suffix.
     * 
     * @return value
     */
    public String getSurname() {
        return surname;
    }

    /** 
     * Set the 'Surname' element value. Individual's hereditaryÂ name(s) common to all members of a family. Also known as family name or last name. E.g. SMITH. Excludes any potential suffix.
     * 
     * @param surname
     */
    public void setSurname(String surname) {
        this.surname = surname;
    }

    /** 
     * Get the 'TitleName' element value. A word such as Mr., Mrs., Miss or Dr that is used before an individual's name to indicate the gender, profession or marital status.
     * 
     * @return value
     */
    public String getTitleName() {
        return titleName;
    }

    /** 
     * Set the 'TitleName' element value. A word such as Mr., Mrs., Miss or Dr that is used before an individual's name to indicate the gender, profession or marital status.
     * 
     * @param titleName
     */
    public void setTitleName(String titleName) {
        this.titleName = titleName;
    }
}
