
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.queueMoveItem.rq;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQMUQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Queue_MoveItem">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element name="placementOption">
 *         &lt;xs:complexType>
 *           &lt;xs:sequence>
 *             &lt;xs:element name="selectionDetails">
 *               &lt;xs:complexType>
 *                 &lt;xs:sequence>
 *                   &lt;xs:element type="xs:string" name="option"/>
 *                 &lt;/xs:sequence>
 *               &lt;/xs:complexType>
 *             &lt;/xs:element>
 *           &lt;/xs:sequence>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *       &lt;xs:element name="targetDetails" maxOccurs="10">
 *         &lt;!-- Reference to inner class TargetDetails -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="messageText" minOccurs="0">
 *         &lt;!-- Reference to inner class MessageText -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="recordLocator" minOccurs="0">
 *         &lt;!-- Reference to inner class RecordLocator -->
 *       &lt;/xs:element>
 *       &lt;xs:element name="numberOfPNRs" minOccurs="0">
 *         &lt;!-- Reference to inner class NumberOfPNRs -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class QueueMoveItem implements Serializable
{
    private String placementOption;
    private List<TargetDetails> targetDetailList = new ArrayList<TargetDetails>();
    private MessageText messageText;
    private RecordLocator recordLocator;
    private NumberOfPNRs numberOfPNRs;

    /** 
     * Get the 'option' element value.
     * 
     * @return value
     */
    public String getPlacementOption() {
        return placementOption;
    }

    /** 
     * Set the 'option' element value.
     * 
     * @param placementOption
     */
    public void setPlacementOption(String placementOption) {
        this.placementOption = placementOption;
    }

    /** 
     * Get the list of 'targetDetails' element items.
     * 
     * @return list
     */
    public List<TargetDetails> getTargetDetailList() {
        return targetDetailList;
    }

    /** 
     * Set the list of 'targetDetails' element items.
     * 
     * @param list
     */
    public void setTargetDetailList(List<TargetDetails> list) {
        targetDetailList = list;
    }

    /** 
     * Get the 'messageText' element value.
     * 
     * @return value
     */
    public MessageText getMessageText() {
        return messageText;
    }

    /** 
     * Set the 'messageText' element value.
     * 
     * @param messageText
     */
    public void setMessageText(MessageText messageText) {
        this.messageText = messageText;
    }

    /** 
     * Get the 'recordLocator' element value.
     * 
     * @return value
     */
    public RecordLocator getRecordLocator() {
        return recordLocator;
    }

    /** 
     * Set the 'recordLocator' element value.
     * 
     * @param recordLocator
     */
    public void setRecordLocator(RecordLocator recordLocator) {
        this.recordLocator = recordLocator;
    }

    /** 
     * Get the 'numberOfPNRs' element value.
     * 
     * @return value
     */
    public NumberOfPNRs getNumberOfPNRs() {
        return numberOfPNRs;
    }

    /** 
     * Set the 'numberOfPNRs' element value.
     * 
     * @param numberOfPNRs
     */
    public void setNumberOfPNRs(NumberOfPNRs numberOfPNRs) {
        this.numberOfPNRs = numberOfPNRs;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQMUQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="targetDetails" maxOccurs="10">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="targetOffice">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element name="sourceType">
     *               &lt;xs:complexType>
     *                 &lt;xs:sequence>
     *                   &lt;xs:element type="xs:string" name="sourceQualifier1"/>
     *                 &lt;/xs:sequence>
     *               &lt;/xs:complexType>
     *             &lt;/xs:element>
     *             &lt;xs:element name="originatorDetails" minOccurs="0">
     *               &lt;!-- Reference to inner class OriginatorDetails -->
     *             &lt;/xs:element>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="queueNumber" minOccurs="0">
     *         &lt;!-- Reference to inner class QueueNumber -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="categoryDetails" minOccurs="0">
     *         &lt;!-- Reference to inner class CategoryDetails -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="placementDate" minOccurs="0">
     *         &lt;!-- Reference to inner class PlacementDate -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TargetDetails implements Serializable
    {
        private String targetOfficeSourceType;
        private OriginatorDetails originatorDetails;
        private QueueNumber queueNumber;
        private CategoryDetails categoryDetails;
        private PlacementDate placementDate;

        /** 
         * Get the 'sourceQualifier1' element value.
         * 
         * @return value
         */
        public String getTargetOfficeSourceType() {
            return targetOfficeSourceType;
        }

        /** 
         * Set the 'sourceQualifier1' element value.
         * 
         * @param targetOfficeSourceType
         */
        public void setTargetOfficeSourceType(String targetOfficeSourceType) {
            this.targetOfficeSourceType = targetOfficeSourceType;
        }

        /** 
         * Get the 'originatorDetails' element value.
         * 
         * @return value
         */
        public OriginatorDetails getOriginatorDetails() {
            return originatorDetails;
        }

        /** 
         * Set the 'originatorDetails' element value.
         * 
         * @param originatorDetails
         */
        public void setOriginatorDetails(OriginatorDetails originatorDetails) {
            this.originatorDetails = originatorDetails;
        }

        /** 
         * Get the 'queueNumber' element value.
         * 
         * @return value
         */
        public QueueNumber getQueueNumber() {
            return queueNumber;
        }

        /** 
         * Set the 'queueNumber' element value.
         * 
         * @param queueNumber
         */
        public void setQueueNumber(QueueNumber queueNumber) {
            this.queueNumber = queueNumber;
        }

        /** 
         * Get the 'categoryDetails' element value.
         * 
         * @return value
         */
        public CategoryDetails getCategoryDetails() {
            return categoryDetails;
        }

        /** 
         * Set the 'categoryDetails' element value.
         * 
         * @param categoryDetails
         */
        public void setCategoryDetails(CategoryDetails categoryDetails) {
            this.categoryDetails = categoryDetails;
        }

        /** 
         * Get the 'placementDate' element value.
         * 
         * @return value
         */
        public PlacementDate getPlacementDate() {
            return placementDate;
        }

        /** 
         * Set the 'placementDate' element value.
         * 
         * @param placementDate
         */
        public void setPlacementDate(PlacementDate placementDate) {
            this.placementDate = placementDate;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQMUQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="originatorDetails" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="inHouseIdentification1"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OriginatorDetails implements Serializable
        {
            private String inHouseIdentification1;

            /** 
             * Get the 'inHouseIdentification1' element value.
             * 
             * @return value
             */
            public String getInHouseIdentification1() {
                return inHouseIdentification1;
            }

            /** 
             * Set the 'inHouseIdentification1' element value.
             * 
             * @param inHouseIdentification1
             */
            public void setInHouseIdentification1(String inHouseIdentification1) {
                this.inHouseIdentification1 = inHouseIdentification1;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQMUQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="queueNumber" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="queueDetails">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element type="xs:decimal" name="number"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class QueueNumber implements Serializable
        {
            private BigDecimal queueDetails;

            /** 
             * Get the 'number' element value.
             * 
             * @return value
             */
            public BigDecimal getQueueDetails() {
                return queueDetails;
            }

            /** 
             * Set the 'number' element value.
             * 
             * @param queueDetails
             */
            public void setQueueDetails(BigDecimal queueDetails) {
                this.queueDetails = queueDetails;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQMUQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="categoryDetails" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="subQueueInfoDetails">
         *         &lt;xs:complexType>
         *           &lt;xs:sequence>
         *             &lt;xs:element type="xs:string" name="identificationType"/>
         *             &lt;xs:element type="xs:string" name="itemNumber" minOccurs="0"/>
         *             &lt;xs:element type="xs:string" name="itemDescription" minOccurs="0"/>
         *           &lt;/xs:sequence>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CategoryDetails implements Serializable
        {
            private String subQueueInfoDetailsIdentificationType;
            private String subQueueInfoDetailsItemNumber;
            private String subQueueInfoDetailsItemDescription;

            /** 
             * Get the 'identificationType' element value.
             * 
             * @return value
             */
            public String getSubQueueInfoDetailsIdentificationType() {
                return subQueueInfoDetailsIdentificationType;
            }

            /** 
             * Set the 'identificationType' element value.
             * 
             * @param subQueueInfoDetailsIdentificationType
             */
            public void setSubQueueInfoDetailsIdentificationType(
                    String subQueueInfoDetailsIdentificationType) {
                this.subQueueInfoDetailsIdentificationType = subQueueInfoDetailsIdentificationType;
            }

            /** 
             * Get the 'itemNumber' element value.
             * 
             * @return value
             */
            public String getSubQueueInfoDetailsItemNumber() {
                return subQueueInfoDetailsItemNumber;
            }

            /** 
             * Set the 'itemNumber' element value.
             * 
             * @param subQueueInfoDetailsItemNumber
             */
            public void setSubQueueInfoDetailsItemNumber(
                    String subQueueInfoDetailsItemNumber) {
                this.subQueueInfoDetailsItemNumber = subQueueInfoDetailsItemNumber;
            }

            /** 
             * Get the 'itemDescription' element value.
             * 
             * @return value
             */
            public String getSubQueueInfoDetailsItemDescription() {
                return subQueueInfoDetailsItemDescription;
            }

            /** 
             * Set the 'itemDescription' element value.
             * 
             * @param subQueueInfoDetailsItemDescription
             */
            public void setSubQueueInfoDetailsItemDescription(
                    String subQueueInfoDetailsItemDescription) {
                this.subQueueInfoDetailsItemDescription = subQueueInfoDetailsItemDescription;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQMUQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="placementDate" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="timeMode" minOccurs="0"/>
         *       &lt;xs:element name="dateTime" minOccurs="0">
         *         &lt;!-- Reference to inner class DateTime -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PlacementDate implements Serializable
        {
            private String timeMode;
            private DateTime dateTime;

            /** 
             * Get the 'timeMode' element value.
             * 
             * @return value
             */
            public String getTimeMode() {
                return timeMode;
            }

            /** 
             * Set the 'timeMode' element value.
             * 
             * @param timeMode
             */
            public void setTimeMode(String timeMode) {
                this.timeMode = timeMode;
            }

            /** 
             * Get the 'dateTime' element value.
             * 
             * @return value
             */
            public DateTime getDateTime() {
                return dateTime;
            }

            /** 
             * Set the 'dateTime' element value.
             * 
             * @param dateTime
             */
            public void setDateTime(DateTime dateTime) {
                this.dateTime = dateTime;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQMUQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="dateTime" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="xs:string" name="year"/>
             *       &lt;xs:element type="xs:decimal" name="month"/>
             *       &lt;xs:element type="xs:decimal" name="day"/>
             *       &lt;xs:element type="xs:decimal" name="hour" minOccurs="0"/>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DateTime implements Serializable
            {
                private String year;
                private BigDecimal month;
                private BigDecimal day;
                private BigDecimal hour;

                /** 
                 * Get the 'year' element value.
                 * 
                 * @return value
                 */
                public String getYear() {
                    return year;
                }

                /** 
                 * Set the 'year' element value.
                 * 
                 * @param year
                 */
                public void setYear(String year) {
                    this.year = year;
                }

                /** 
                 * Get the 'month' element value.
                 * 
                 * @return value
                 */
                public BigDecimal getMonth() {
                    return month;
                }

                /** 
                 * Set the 'month' element value.
                 * 
                 * @param month
                 */
                public void setMonth(BigDecimal month) {
                    this.month = month;
                }

                /** 
                 * Get the 'day' element value.
                 * 
                 * @return value
                 */
                public BigDecimal getDay() {
                    return day;
                }

                /** 
                 * Set the 'day' element value.
                 * 
                 * @param day
                 */
                public void setDay(BigDecimal day) {
                    this.day = day;
                }

                /** 
                 * Get the 'hour' element value.
                 * 
                 * @return value
                 */
                public BigDecimal getHour() {
                    return hour;
                }

                /** 
                 * Set the 'hour' element value.
                 * 
                 * @param hour
                 */
                public void setHour(BigDecimal hour) {
                    this.hour = hour;
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQMUQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="messageText" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="freeTextDetails" minOccurs="0">
     *         &lt;!-- Reference to inner class FreeTextDetails -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="freeText" maxOccurs="99"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class MessageText implements Serializable
    {
        private FreeTextDetails freeTextDetails;
        private List<String> freeTextList = new ArrayList<String>();

        /** 
         * Get the 'freeTextDetails' element value.
         * 
         * @return value
         */
        public FreeTextDetails getFreeTextDetails() {
            return freeTextDetails;
        }

        /** 
         * Set the 'freeTextDetails' element value.
         * 
         * @param freeTextDetails
         */
        public void setFreeTextDetails(FreeTextDetails freeTextDetails) {
            this.freeTextDetails = freeTextDetails;
        }

        /** 
         * Get the list of 'freeText' element items.
         * 
         * @return list
         */
        public List<String> getFreeTextList() {
            return freeTextList;
        }

        /** 
         * Set the list of 'freeText' element items.
         * 
         * @param list
         */
        public void setFreeTextList(List<String> list) {
            freeTextList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQMUQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="freeTextDetails" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="textSubjectQualifier"/>
         *       &lt;xs:element type="xs:string" name="source" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="encoding" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FreeTextDetails implements Serializable
        {
            private String textSubjectQualifier;
            private String source;
            private String encoding;

            /** 
             * Get the 'textSubjectQualifier' element value.
             * 
             * @return value
             */
            public String getTextSubjectQualifier() {
                return textSubjectQualifier;
            }

            /** 
             * Set the 'textSubjectQualifier' element value.
             * 
             * @param textSubjectQualifier
             */
            public void setTextSubjectQualifier(String textSubjectQualifier) {
                this.textSubjectQualifier = textSubjectQualifier;
            }

            /** 
             * Get the 'source' element value.
             * 
             * @return value
             */
            public String getSource() {
                return source;
            }

            /** 
             * Set the 'source' element value.
             * 
             * @param source
             */
            public void setSource(String source) {
                this.source = source;
            }

            /** 
             * Get the 'encoding' element value.
             * 
             * @return value
             */
            public String getEncoding() {
                return encoding;
            }

            /** 
             * Set the 'encoding' element value.
             * 
             * @param encoding
             */
            public void setEncoding(String encoding) {
                this.encoding = encoding;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQMUQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="recordLocator" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="reservation">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:string" name="controlNumber"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class RecordLocator implements Serializable
    {
        private String reservation;

        /** 
         * Get the 'controlNumber' element value.
         * 
         * @return value
         */
        public String getReservation() {
            return reservation;
        }

        /** 
         * Set the 'controlNumber' element value.
         * 
         * @param reservation
         */
        public void setReservation(String reservation) {
            this.reservation = reservation;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQMUQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="numberOfPNRs" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="quantityDetails">
     *         &lt;xs:complexType>
     *           &lt;xs:sequence>
     *             &lt;xs:element type="xs:decimal" name="numberOfUnit"/>
     *           &lt;/xs:sequence>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class NumberOfPNRs implements Serializable
    {
        private BigDecimal quantityDetails;

        /** 
         * Get the 'numberOfUnit' element value.
         * 
         * @return value
         */
        public BigDecimal getQuantityDetails() {
            return quantityDetails;
        }

        /** 
         * Set the 'numberOfUnit' element value.
         * 
         * @param quantityDetails
         */
        public void setQuantityDetails(BigDecimal quantityDetails) {
            this.quantityDetails = quantityDetails;
        }
    }
}
