
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Earliest and Latest Period than an option is available or may be used.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AvailPeriodType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DateTimeType" name="EarliestAvailablePeriodDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="LatestAvailablePeriodDateTime" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AvailPeriodType implements Serializable
{
    private DateTimeType earliestAvailablePeriodDateTime;
    private DateTimeType latestAvailablePeriodDateTime;

    /** 
     * Get the 'EarliestAvailablePeriodDateTime' element value. Offer/ Order term (condition) for the Earliest time an item is Available or May be Used.
     * 
     * @return value
     */
    public DateTimeType getEarliestAvailablePeriodDateTime() {
        return earliestAvailablePeriodDateTime;
    }

    /** 
     * Set the 'EarliestAvailablePeriodDateTime' element value. Offer/ Order term (condition) for the Earliest time an item is Available or May be Used.
     * 
     * @param earliestAvailablePeriodDateTime
     */
    public void setEarliestAvailablePeriodDateTime(
            DateTimeType earliestAvailablePeriodDateTime) {
        this.earliestAvailablePeriodDateTime = earliestAvailablePeriodDateTime;
    }

    /** 
     * Get the 'LatestAvailablePeriodDateTime' element value. Offer/ Order term (condition) for the Latest time an item is Available or May be Used.
     * 
     * @return value
     */
    public DateTimeType getLatestAvailablePeriodDateTime() {
        return latestAvailablePeriodDateTime;
    }

    /** 
     * Set the 'LatestAvailablePeriodDateTime' element value. Offer/ Order term (condition) for the Latest time an item is Available or May be Used.
     * 
     * @param latestAvailablePeriodDateTime
     */
    public void setLatestAvailablePeriodDateTime(
            DateTimeType latestAvailablePeriodDateTime) {
        this.latestAvailablePeriodDateTime = latestAvailablePeriodDateTime;
    }
}
