
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Disclosure information specifically related to baggage.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BaggageDisclosureType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="BaggageDisclosureID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:BDC_Type" name="BDC" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="CheckInChargesInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CommercialAgreementID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="DeferralInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DescType" name="Desc" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="DescText" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:boolean" name="FixedPrePaidInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:BagDisclosureRuleTypeCodeContentType" name="RuleTypeCode" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BaggageDisclosureType implements Serializable
{
    private String baggageDisclosureID;
    private BDCType BDC;
    private Boolean checkInChargesInd;
    private String commercialAgreementID;
    private Boolean deferralInd;
    private List<DescType> descList = new ArrayList<DescType>();
    private List<String> descTextList = new ArrayList<String>();
    private Boolean fixedPrePaidInd;
    private BagDisclosureRuleTypeCodeContentType ruleTypeCode;

    /** 
     * Get the 'BaggageDisclosureID' element value. Uniquely identifies a Bag Disclosure within the message.
     * 
     * @return value
     */
    public String getBaggageDisclosureID() {
        return baggageDisclosureID;
    }

    /** 
     * Set the 'BaggageDisclosureID' element value. Uniquely identifies a Bag Disclosure within the message.
     * 
     * @param baggageDisclosureID
     */
    public void setBaggageDisclosureID(String baggageDisclosureID) {
        this.baggageDisclosureID = baggageDisclosureID;
    }

    /** 
     * Get the 'BDC' element value. The carrier whose baggage allowances and charges apply.
     * 
     * @return value
     */
    public BDCType getBDC() {
        return BDC;
    }

    /** 
     * Set the 'BDC' element value. The carrier whose baggage allowances and charges apply.
     * 
     * @param BDC
     */
    public void setBDC(BDCType BDC) {
        this.BDC = BDC;
    }

    /** 
     * Get the 'CheckInChargesInd' element value. If TRUE, additional taxes, fees and charges may be collected at check-in (regionally determined).
     * 
     * @return value
     */
    public Boolean getCheckInChargesInd() {
        return checkInChargesInd;
    }

    /** 
     * Set the 'CheckInChargesInd' element value. If TRUE, additional taxes, fees and charges may be collected at check-in (regionally determined).
     * 
     * @param checkInChargesInd
     */
    public void setCheckInChargesInd(Boolean checkInChargesInd) {
        this.checkInChargesInd = checkInChargesInd;
    }

    /** 
     * Get the 'CommercialAgreementID' element value. Bilateral agreement identifier E.g. baggage cost, Baggage Determining Carrier, etc.
     * 
     * @return value
     */
    public String getCommercialAgreementID() {
        return commercialAgreementID;
    }

    /** 
     * Set the 'CommercialAgreementID' element value. Bilateral agreement identifier E.g. baggage cost, Baggage Determining Carrier, etc.
     * 
     * @param commercialAgreementID
     */
    public void setCommercialAgreementID(String commercialAgreementID) {
        this.commercialAgreementID = commercialAgreementID;
    }

    /** 
     * Get the 'DeferralInd' element value. If TRUE, The ORA advises the POA that the POA is given the Baggage Determining Carrier designation
     * 
     * @return value
     */
    public Boolean getDeferralInd() {
        return deferralInd;
    }

    /** 
     * Set the 'DeferralInd' element value. If TRUE, The ORA advises the POA that the POA is given the Baggage Determining Carrier designation
     * 
     * @param deferralInd
     */
    public void setDeferralInd(Boolean deferralInd) {
        this.deferralInd = deferralInd;
    }

    /** 
     * Get the list of 'Desc' element items. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @return list
     */
    public List<DescType> getDescList() {
        return descList;
    }

    /** 
     * Set the list of 'Desc' element items. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @param list
     */
    public void setDescList(List<DescType> list) {
        descList = list;
    }

    /** 
     * Get the list of 'DescText' element items. Description text value.
     * 
     * @return list
     */
    public List<String> getDescTextList() {
        return descTextList;
    }

    /** 
     * Set the list of 'DescText' element items. Description text value.
     * 
     * @param list
     */
    public void setDescTextList(List<String> list) {
        descTextList = list;
    }

    /** 
     * Get the 'FixedPrePaidInd' element value. Allows POA to tell the ORA if the ORA may alter the POAâ€™s pre-paid baggage charges.  If TRUE, prepaid charge may NOT be altered If FALSE, prepaid charge MAY be altered
     * 
     * @return value
     */
    public Boolean getFixedPrePaidInd() {
        return fixedPrePaidInd;
    }

    /** 
     * Set the 'FixedPrePaidInd' element value. Allows POA to tell the ORA if the ORA may alter the POAâ€™s pre-paid baggage charges.  If TRUE, prepaid charge may NOT be altered If FALSE, prepaid charge MAY be altered
     * 
     * @param fixedPrePaidInd
     */
    public void setFixedPrePaidInd(Boolean fixedPrePaidInd) {
        this.fixedPrePaidInd = fixedPrePaidInd;
    }

    /** 
     * Get the 'RuleTypeCode' element value. US Department of Transportation (DOT) Reservation or Disclosure baggage rule. Examples: Y, Disclosure AND US DOT Reservation
     * 
     * @return value
     */
    public BagDisclosureRuleTypeCodeContentType getRuleTypeCode() {
        return ruleTypeCode;
    }

    /** 
     * Set the 'RuleTypeCode' element value. US Department of Transportation (DOT) Reservation or Disclosure baggage rule. Examples: Y, Disclosure AND US DOT Reservation
     * 
     * @param ruleTypeCode
     */
    public void setRuleTypeCode(
            BagDisclosureRuleTypeCodeContentType ruleTypeCode) {
        this.ruleTypeCode = ruleTypeCode;
    }
}
