
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * A bilaterally agreed limitation or restriction of time.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BilateralTimeLimitType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DescText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="TimeLimitDateTime" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BilateralTimeLimitType implements Serializable
{
    private String descText;
    private String name;
    private DateTimeType timeLimitDateTime;

    /** 
     * Get the 'DescText' element value. Additional text to supplement a specified time limit.
     * 
     * @return value
     */
    public String getDescText() {
        return descText;
    }

    /** 
     * Set the 'DescText' element value. Additional text to supplement a specified time limit.
     * 
     * @param descText
     */
    public void setDescText(String descText) {
        this.descText = descText;
    }

    /** 
     * Get the 'Name' element value. Bilaterally-agreed time limit name.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Bilaterally-agreed time limit name.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'TimeLimitDateTime' element value. Date and time of the time limit. E.g. 2017-05-30T09:00:00
     * 
     * @return value
     */
    public DateTimeType getTimeLimitDateTime() {
        return timeLimitDateTime;
    }

    /** 
     * Set the 'TimeLimitDateTime' element value. Date and time of the time limit. E.g. 2017-05-30T09:00:00
     * 
     * @param timeLimitDateTime
     */
    public void setTimeLimitDateTime(DateTimeType timeLimitDateTime) {
        this.timeLimitDateTime = timeLimitDateTime;
    }
}
