
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Carrier defined internal grouping of aircrafts with the same form, function and specification.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarrierAircraftTypeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CarrierAircraftTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CarrierAircraftTypeName" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CarrierAircraftTypeType implements Serializable
{
    private String carrierAircraftTypeCode;
    private String carrierAircraftTypeName;

    /** 
     * Get the 'CarrierAircraftTypeCode' element value. Internal code used by an carrier to identify the type of aircraft.
     * 
     * @return value
     */
    public String getCarrierAircraftTypeCode() {
        return carrierAircraftTypeCode;
    }

    /** 
     * Set the 'CarrierAircraftTypeCode' element value. Internal code used by an carrier to identify the type of aircraft.
     * 
     * @param carrierAircraftTypeCode
     */
    public void setCarrierAircraftTypeCode(String carrierAircraftTypeCode) {
        this.carrierAircraftTypeCode = carrierAircraftTypeCode;
    }

    /** 
     * Get the 'CarrierAircraftTypeName' element value. Internal name given by the carrier to this aircraft type.
     * 
     * @return value
     */
    public String getCarrierAircraftTypeName() {
        return carrierAircraftTypeName;
    }

    /** 
     * Set the 'CarrierAircraftTypeName' element value. Internal name given by the carrier to this aircraft type.
     * 
     * @param carrierAircraftTypeName
     */
    public void setCarrierAircraftTypeName(String carrierAircraftTypeName) {
        this.carrierAircraftTypeName = carrierAircraftTypeName;
    }
}
